/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.BloodRankEntry;
import java.util.List;
import java.util.Map;

public class BloodRankLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/blood-rank-%s.csv";
    private final CsvContentReader<BloodRankEntry> contentProvider = new CsvContentReader<BloodRankEntry>(BloodRankEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public BloodRankLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, BloodRankEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, BloodRankEntry> generate(String csvFile) {
        List<BloodRankEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(BloodRankEntry::getHcpcsCode, content);
    }
}

