/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.opps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.opps.core.tables.OutMigrationAdjustmentEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class OutMigrationAdjustmentLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/outmigration-adjustment-%s.csv";
    private final CsvContentReader<OutMigrationAdjustmentEntry> contentProvider = new CsvContentReader<OutMigrationAdjustmentEntry>(OutMigrationAdjustmentEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public OutMigrationAdjustmentLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<Integer, NavigableMap<LocalDate, OutMigrationAdjustmentEntry>> generate(String csvFile) {
        List<OutMigrationAdjustmentEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<OutMigrationAdjustmentEntry, ?, NavigableMap> collector = Collectors.toMap(OutMigrationAdjustmentEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(OutMigrationAdjustmentEntry::getCounty, content, HashMap::new, collector);
    }
}

