/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

public enum DataSizeUnit {
    BYTES(8L),
    KILOBYTES(8000L),
    MEGABYTES(8000000L),
    GIGABYTES(8000000000L),
    TERABYTES(8000000000000L),
    PETABYTES(8000000000000000L),
    KIBIBYTES(8192L),
    MEBIBYTES(0x800000L),
    GIBIBYTES(0x200000000L),
    TEBIBYTES(0x80000000000L),
    PEBIBYTES(0x20000000000000L);

    private final long bits;

    private DataSizeUnit(long bits) {
        this.bits = bits;
    }

    public long convert(long size, DataSizeUnit unit) {
        return size * unit.bits / this.bits;
    }

    public long toBytes(long l) {
        return BYTES.convert(l, this);
    }

    public long toKilobytes(long l) {
        return KILOBYTES.convert(l, this);
    }

    public long toMegabytes(long l) {
        return MEGABYTES.convert(l, this);
    }

    public long toGigabytes(long l) {
        return GIGABYTES.convert(l, this);
    }

    public long toTerabytes(long l) {
        return TERABYTES.convert(l, this);
    }

    public long toPetabytes(long l) {
        return PETABYTES.convert(l, this);
    }

    public long toKibibytes(long l) {
        return KIBIBYTES.convert(l, this);
    }

    public long toMebibytes(long l) {
        return MEBIBYTES.convert(l, this);
    }

    public long toGibibytes(long l) {
        return GIBIBYTES.convert(l, this);
    }

    public long toTebibytes(long l) {
        return TEBIBYTES.convert(l, this);
    }

    public long toPebibytes(long l) {
        return PEBIBYTES.convert(l, this);
    }
}

