/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.RecordWriteResult;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.nio.AbstractNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.DirectByteBufferRecord;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOUtils;

public final class TCPNIOAsyncQueueWriter
extends AbstractNIOAsyncQueueWriter {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOAsyncQueueWriter.class);
    private static final Attribute<CompositeQueueRecord> COMPOSITE_BUFFER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(TCPNIOAsyncQueueWriter.class.getName() + ".compositeBuffer");

    public TCPNIOAsyncQueueWriter(NIOTransport transport) {
        super(transport);
    }

    @Override
    protected RecordWriteResult write0(NIOConnection connection, AsyncWriteQueueRecord queueRecord) throws IOException {
        if (queueRecord instanceof CompositeQueueRecord) {
            return this.writeCompositeRecord(connection, (CompositeQueueRecord)queueRecord);
        }
        RecordWriteResult writeResult = queueRecord.getCurrentResult();
        if (queueRecord.remaining() == 0L) {
            return writeResult.lastWriteResult(0L, queueRecord.isUncountable() ? 1L : 0L);
        }
        long written = this.write0(connection, queueRecord.getWritableMessage(), writeResult);
        return writeResult.lastWriteResult(written, written);
    }

    protected long write0(NIOConnection connection, WritableMessage message, WriteResult<WritableMessage, SocketAddress> currentResult) throws IOException {
        long written;
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            try {
                written = !buffer.hasRemaining() ? 0L : (!buffer.isComposite() ? (long)TCPNIOUtils.writeSimpleBuffer((TCPNIOConnection)connection, buffer) : (long)TCPNIOUtils.writeCompositeBuffer((TCPNIOConnection)connection, (CompositeBuffer)buffer));
                ((TCPNIOConnection)connection).onWrite(buffer, written);
            }
            catch (IOException e) {
                ((TCPNIOConnection)connection).terminate0(null, new CloseReason(CloseType.REMOTELY, e));
                throw e;
            }
        } else if (message instanceof FileTransfer) {
            written = ((FileTransfer)message).writeTo((SocketChannel)connection.getChannel());
            ((TCPNIOConnection)connection).onWrite(null, written);
        } else {
            throw new IllegalStateException("Unhandled message type");
        }
        if (currentResult != null) {
            currentResult.setMessage(message);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddressHolder(((TCPNIOConnection)connection).peerSocketAddressHolder);
        }
        return written;
    }

    private RecordWriteResult writeCompositeRecord(NIOConnection connection, CompositeQueueRecord queueRecord) throws IOException {
        int written = 0;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "writeCompositeRecord connection={0}, queueRecord={1}, queueRecord.remaining={2}, queueRecord.queue.size()={3}", new Object[]{connection, queueRecord, queueRecord.remaining(), queueRecord.queue.size()});
        }
        if (queueRecord.size > 0) {
            int bufferSize = Math.min(queueRecord.size, connection.getWriteBufferSize() * 3 / 2);
            DirectByteBufferRecord directByteBufferRecord = DirectByteBufferRecord.get();
            try {
                SocketChannel socketChannel = (SocketChannel)connection.getChannel();
                TCPNIOAsyncQueueWriter.fill(queueRecord, bufferSize, directByteBufferRecord);
                directByteBufferRecord.finishBufferSlice();
                int arraySize = directByteBufferRecord.getArraySize();
                written = arraySize == 1 ? TCPNIOUtils.flushByteBuffer(socketChannel, directByteBufferRecord.getArray()[0]) : TCPNIOUtils.flushByteBuffers(socketChannel, directByteBufferRecord.getArray(), 0, arraySize);
            }
            catch (IOException e) {
                ((TCPNIOConnection)connection).terminate0(null, new CloseReason(CloseType.REMOTELY, e));
                throw e;
            }
            finally {
                directByteBufferRecord.release();
            }
        }
        return this.update(queueRecord, written);
    }

    private static void fill(CompositeQueueRecord queueRecord, int totalBufferSize, DirectByteBufferRecord ioRecord) {
        int totalRemaining = totalBufferSize;
        Deque queue = queueRecord.queue;
        ArrayList savedBufferStates = queueRecord.savedBufferStates;
        Iterator it = queue.iterator();
        while (it.hasNext() && totalRemaining > 0) {
            AsyncWriteQueueRecord record = (AsyncWriteQueueRecord)it.next();
            if (record.isUncountable()) continue;
            Buffer message = (Buffer)record.getMessage();
            int pos = message.position();
            int messageRemaining = message.remaining();
            BufferArray bufferArray = totalRemaining >= messageRemaining ? message.toBufferArray() : message.toBufferArray(pos, pos + totalRemaining);
            savedBufferStates.add(bufferArray);
            TCPNIOUtils.fill(bufferArray, totalRemaining, ioRecord);
            totalRemaining -= messageRemaining;
        }
    }

    private RecordWriteResult update(CompositeQueueRecord queueRecord, int written) {
        AsyncWriteQueueRecord record;
        for (int i2 = 0; i2 < queueRecord.savedBufferStates.size(); ++i2) {
            BufferArray savedState = (BufferArray)queueRecord.savedBufferStates.get(i2);
            if (savedState == null) continue;
            savedState.restore();
            savedState.recycle();
        }
        int extraBytesToRelease = 0;
        queueRecord.savedBufferStates.clear();
        int remainder = written;
        queueRecord.size = queueRecord.size - written;
        Connection connection = queueRecord.getConnection();
        Deque queue = queueRecord.queue;
        while (remainder > 0) {
            record = (AsyncWriteQueueRecord)queue.peekFirst();
            assert (record != null);
            if (record.isUncountable()) {
                queue.removeFirst();
                record.notifyCompleteAndRecycle();
                ++extraBytesToRelease;
                continue;
            }
            RecordWriteResult firstResult = record.getCurrentResult();
            Buffer firstMessage = (Buffer)record.getMessage();
            long firstMessageRemaining = record.getInitialMessageSize() - firstResult.getWrittenSize();
            if ((long)remainder >= firstMessageRemaining) {
                remainder = (int)((long)remainder - firstMessageRemaining);
                queue.removeFirst();
                firstResult.setWrittenSize(record.getInitialMessageSize());
                firstMessage.position(firstMessage.limit());
                ((TCPNIOConnection)connection).onWrite(firstMessage, firstMessageRemaining);
                record.notifyCompleteAndRecycle();
                continue;
            }
            firstMessage.position(firstMessage.position() + remainder);
            firstResult.setWrittenSize(firstResult.getWrittenSize() + (long)remainder);
            ((TCPNIOConnection)connection).onWrite(firstMessage, remainder);
            return queueRecord.getCurrentResult().lastWriteResult(written, written + extraBytesToRelease);
        }
        while ((record = (AsyncWriteQueueRecord)queue.peekFirst()) != null && record.isUncountable()) {
            queue.removeFirst();
            record.notifyCompleteAndRecycle();
            ++extraBytesToRelease;
        }
        return queueRecord.getCurrentResult().lastWriteResult(written, written + extraBytesToRelease);
    }

    @Override
    protected final void onReadyToWrite(NIOConnection connection) throws IOException {
        connection.enableIOEvent(IOEvent.WRITE);
    }

    @Override
    protected AsyncWriteQueueRecord aggregate(TaskQueue<AsyncWriteQueueRecord> writeTaskQueue) {
        int queueSize = writeTaskQueue.size();
        if (queueSize == 0) {
            return null;
        }
        AsyncWriteQueueRecord currentRecord = writeTaskQueue.poll();
        if (currentRecord == null || !TCPNIOAsyncQueueWriter.canBeAggregated(currentRecord) || (long)queueSize == currentRecord.remaining()) {
            return currentRecord;
        }
        AsyncWriteQueueRecord nextRecord = TCPNIOAsyncQueueWriter.checkAndGetNextRecord(writeTaskQueue);
        if (nextRecord == null) {
            return currentRecord;
        }
        CompositeQueueRecord compositeQueueRecord = this.createCompositeQueueRecord(currentRecord);
        do {
            compositeQueueRecord.append(nextRecord);
        } while (compositeQueueRecord.remaining() < (long)queueSize && (nextRecord = TCPNIOAsyncQueueWriter.checkAndGetNextRecord(writeTaskQueue)) != null);
        return compositeQueueRecord;
    }

    private static AsyncWriteQueueRecord checkAndGetNextRecord(TaskQueue<AsyncWriteQueueRecord> writeTaskQueue) {
        AsyncWriteQueueRecord nextRecord = writeTaskQueue.getQueue().poll();
        if (nextRecord == null) {
            return null;
        }
        if (!TCPNIOAsyncQueueWriter.canBeAggregated(nextRecord)) {
            writeTaskQueue.setCurrentElement(nextRecord);
            return null;
        }
        return nextRecord;
    }

    private static boolean canBeAggregated(AsyncWriteQueueRecord record) {
        return record.canBeAggregated();
    }

    private CompositeQueueRecord createCompositeQueueRecord(AsyncWriteQueueRecord currentRecord) {
        if (!(currentRecord instanceof CompositeQueueRecord)) {
            Connection connection = currentRecord.getConnection();
            CompositeQueueRecord compositeQueueRecord = COMPOSITE_BUFFER_ATTR.get(connection);
            if (compositeQueueRecord == null) {
                compositeQueueRecord = CompositeQueueRecord.create(connection);
                COMPOSITE_BUFFER_ATTR.set(connection, compositeQueueRecord);
            }
            compositeQueueRecord.append(currentRecord);
            return compositeQueueRecord;
        }
        return (CompositeQueueRecord)currentRecord;
    }

    private static final class CompositeQueueRecord
    extends AsyncWriteQueueRecord {
        private final ArrayList<BufferArray> savedBufferStates = new ArrayList(2);
        private final Deque<AsyncWriteQueueRecord> queue = new ArrayDeque<AsyncWriteQueueRecord>(2);
        private int size;

        public static CompositeQueueRecord create(Connection connection) {
            return new CompositeQueueRecord(connection);
        }

        public CompositeQueueRecord(Connection connection) {
            super(connection, null, null, null, null, false);
        }

        public void append(AsyncWriteQueueRecord queueRecord) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "CompositeQueueRecord.append. connection={0}, this={1}, comp-size={2}, elem-count={3}, queueRecord={4}, newrec-size={5}, isEmpty={6}", new Object[]{this.connection, this, this.size, this.queue.size(), queueRecord, queueRecord.remaining(), queueRecord.isUncountable()});
            }
            this.size = (int)((long)this.size + queueRecord.remaining());
            this.queue.add(queueRecord);
        }

        @Override
        public boolean isUncountable() {
            return false;
        }

        @Override
        public boolean isFinished() {
            return this.size == 0;
        }

        @Override
        public boolean canBeAggregated() {
            return true;
        }

        @Override
        public long remaining() {
            return this.size;
        }

        @Override
        public void notifyCompleteAndRecycle() {
        }

        @Override
        public void notifyFailure(Throwable e) {
            AsyncWriteQueueRecord record;
            while ((record = this.queue.poll()) != null) {
                record.notifyFailure(e);
            }
        }

        @Override
        public void recycle() {
        }
    }
}

