/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class BufferOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 8192;
    final MemoryManager mm;
    final boolean reallocate;
    private Buffer currentBuffer;
    private CompositeBuffer compositeBuffer;

    public BufferOutputStream(MemoryManager mm4) {
        this(mm4, null);
    }

    public BufferOutputStream(MemoryManager mm4, Buffer buffer) {
        this(mm4, buffer, false);
    }

    public BufferOutputStream(MemoryManager mm4, Buffer buffer, boolean reallocate) {
        this.currentBuffer = buffer;
        this.mm = mm4;
        this.reallocate = reallocate;
    }

    public void setInitialOutputBuffer(Buffer initialBuffer) {
        if (this.currentBuffer != null || this.compositeBuffer != null) {
            throw new IllegalStateException("Can not set initial buffer on non-reset OutputStream");
        }
        this.currentBuffer = initialBuffer;
    }

    public Buffer getBuffer() {
        if (this.reallocate || this.compositeBuffer == null) {
            return this.currentBuffer != null ? this.currentBuffer : Buffers.EMPTY_BUFFER;
        }
        if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.flushCurrent();
        }
        return this.compositeBuffer;
    }

    public boolean isReallocate() {
        return this.reallocate;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.currentBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureCapacity(len);
        this.currentBuffer.put(b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public void reset() {
        this.currentBuffer = null;
        this.compositeBuffer = null;
    }

    protected Buffer allocateNewBuffer(MemoryManager memoryManager, int size) {
        return memoryManager.allocate(size);
    }

    private void ensureCapacity(int len) {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.allocateNewBuffer(this.mm, Math.max(8192, len));
        } else if (this.currentBuffer.remaining() < len) {
            if (this.reallocate) {
                this.currentBuffer = this.mm.reallocate(this.currentBuffer, Math.max(this.currentBuffer.capacity() + len, this.currentBuffer.capacity() * 3 / 2 + 1));
            } else {
                this.flushCurrent();
                this.currentBuffer = this.allocateNewBuffer(this.mm, Math.max(8192, len));
            }
        }
    }

    private void flushCurrent() {
        this.currentBuffer.trim();
        if (this.compositeBuffer == null) {
            this.compositeBuffer = CompositeBuffer.newBuffer(this.mm);
        }
        this.compositeBuffer.append(this.currentBuffer);
        this.compositeBuffer.position(this.compositeBuffer.limit());
        this.currentBuffer = null;
    }
}

