/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.security.SecureRandom;
import org.glassfish.grizzly.Buffer;

public class Masker {
    private Buffer buffer;
    private byte[] mask;
    private int index = 0;

    public Masker(Buffer buffer) {
        this.buffer = buffer;
    }

    public Masker() {
        this.generateMask();
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte[] get(int size) {
        byte[] bytes = new byte[size];
        this.buffer.get(bytes);
        return bytes;
    }

    public byte unmask() {
        byte b = this.get();
        return this.mask == null ? b : (byte)(b ^ this.mask[this.index++ % 4]);
    }

    public byte[] unmask(int count) {
        byte[] bytes = this.get(count);
        if (this.mask != null) {
            int i2 = 0;
            while (i2 < bytes.length) {
                int n = i2++;
                bytes[n] = (byte)(bytes[n] ^ this.mask[this.index++ % 4]);
            }
        }
        return bytes;
    }

    public void generateMask() {
        this.mask = new byte[4];
        new SecureRandom().nextBytes(this.mask);
    }

    public void mask(byte[] bytes, int location, byte b) {
        bytes[location] = this.mask == null ? b : (byte)(b ^ this.mask[this.index++ % 4]);
    }

    public void mask(byte[] target, int location, byte[] bytes) {
        if (bytes != null && target != null) {
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                target[location + i2] = this.mask == null ? bytes[i2] : (byte)(bytes[i2] ^ this.mask[this.index++ % 4]);
            }
        }
    }

    public byte[] maskAndPrepend(byte[] packet) {
        byte[] masked = new byte[packet.length + 4];
        System.arraycopy(this.getMask(), 0, masked, 0, 4);
        this.mask(masked, 4, packet);
        return masked;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public void readMask() {
        this.mask = this.get(4);
    }
}

