* program name: ContractContacts2022.sas;
* Reads the Contract Level Contact Information Data Extract, ContractContacts2022.txt;

options pageno=1 nocenter;

proc format;
value $bocfmt
'1' = 'Non Lock-In Beneficiary - CMS to process all claims'
'2' = 'Non Lock-In Beneficiary - Plan to process only in-plan Part A and in-area Part B claims'
'4' = 'Chronic Care Orgs - CMS to process all claims'
'5' = 'PDPs'
'A' = 'Lock-In Beneficiary - CMS to process all claims'
'B' = 'Lock-In Beneficiary - Plan to process only in-plan Part A and in-area Part B claims'
'C' = 'Lock-In Beneficiary - Plan to process all Part A and Part B claims';
run;

data contacts;

infile '.\ContractContacts2022.txt'
        lrecl=3000 firstobs=2 delimiter='09'x dsd missover;

Length
  contract_id                $5
  role                       $500
  title                      $50
  prefix                     $4
  last_name                  $20
  first_name                 $10
  mi                         $1
  phone                      $14
  phone_ext                  $7
  alt_phone                  $14
  alt_phone_ext              $7
  fax                        $14
  email                      $50
  street_address             $100
  street_address2            $55
  city                       $30
  state_code                 $2
  zip                        $10
  last_updated               $10
  contract_year              $4
  contract_name              $150
  org_type                   $50
  marketing_name             $150
  contract_plan_type         $50
  employer                   $100
  parent_organization_name   $50
  partd_offered              $3
  contract_status            $50
  tollfree_phone             $14
  tollfree_ext               $7
  alt_tollfree_phone         $14
  alt_tollfree_phone_ext     $7
  new_payment_bill_option    $50
  demo_type_flag             $50
  bill_option_code           $1
  region_responsible         $25
;

Input
  contract_id
  role
  title
  prefix
  last_name
  first_name
  mi
  phone
  phone_ext
  alt_phone
  alt_phone_ext
  fax
  email
  street_address
  street_address2
  city
  state_code
  zip
  last_updated
  contract_year
  contract_name
  org_type
  marketing_name
  contract_plan_type
  employer
  parent_organization_name
  parent_organization_id
  partd_offered
  contract_status
  tollfree_phone
  tollfree_ext
  alt_tollfree_phone
  alt_tollfree_phone_ext
  new_payment_bill_option
  demo_type_flag
  bill_option_code
  region_responsible
;

Label
  contract_id                = "Contract Id"
  role                       = "Contact Role"
  title                      = "Title"
  prefix                     = "Name Prefix"
  last_name                  = "Last Name"
  first_name                 = "First Name"
  mi                         = "Middle Initial"
  phone                      = "Phone Number"
  phone_ext                  = "Phone Extension"
  alt_phone                  = "TTY/TDD Phone Number"
  alt_phone_ext              = "TTY/TDD Phone Extension"
  fax                        = "Fax Number"
  email                      = "Email Address"
  street_address             = "Street Address"
  street_address2            = "Street Address 2"
  city                       = "City"
  state_code                 = "State"
  zip                        = "Zipcode"
  last_updated               = "Date of Last Update"
  contract_year              = "Contract Year"
  contract_name              = "Contract Name"
  org_type                   = "Organization Type"
  marketing_name             = "Organization Marketing Name"
  contract_plan_type         = "Contract Plan Type"
  employer                   = "PHR Company Name"
  parent_organization_name   = "Parent Organization Description"
  parent_organization_id     = "Parent Identifiaction Number"
  partd_offered              = "Part D Offered"
  contract_status            = "Contract Status"
  tollfree_phone             = "Toll-free Phone Number"
  tollfree_ext               = "Toll-free Phone Extension"
  alt_tollfree_phone         = "TTY/TDD Toll-free Phone Number"
  alt_tollfree_phone_ext     = "TTY/TDD Toll-free Phone Extension"
  new_payment_bill_option    = "New Payment Bill Option"
  demo_type_flag             = "Demo Type"
  bill_option_code           = "Bill Option Code"
  region_responsible         = "Responsible Region"
;
run;

proc print data = contacts (obs = 10);
format bill_option_code $bocfmt.;
title 'Contract Level Contact Information Data';
run;

proc freq data = contacts;
tables role contract_year org_type bill_option_code;
run;

proc contents data = contacts;
title 'Contract Level Contact Information Data';
run;
