/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.lego;

import gov.cms.grouper.snf.lego.BetweenCompare;
import gov.cms.grouper.snf.lego.SnfComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public class Compare<T extends Comparable<T>> {
    private final SnfComparator.AcceptNull accept;
    private final BetweenCompare<Integer> between;

    public Compare(SnfComparator.AcceptNull accept) {
        this.accept = accept;
        this.between = BetweenCompare.of(this.accept, this.accept);
    }

    private boolean compute(Comparator<T> comparator, T thisValue, T against, Function<Integer, Boolean> eval) {
        boolean checkNull = this.accept.checkNull(Arrays.asList(thisValue, against));
        boolean result = checkNull && this.compare(thisValue, against, eval);
        return result;
    }

    private boolean compare(T thisValue, T against, Function<Integer, Boolean> eval) {
        Comparator<T> com = this.accept.getComparator();
        int computeValue = com.compare(thisValue, against);
        boolean result = eval.apply(computeValue);
        return result;
    }

    public boolean lte(T thisValue, T isLessThanThis) {
        boolean result = this.compute(this.accept.getComparator(), thisValue, isLessThanThis, com -> this.between.betweenInclusive(-1, (Integer)com, 0));
        return result;
    }

    public boolean lt(T thisValue, T isLessThanThis) {
        boolean result = this.compute(this.accept.getComparator(), thisValue, isLessThanThis, com -> this.between.betweenInclusive(-1, (Integer)com, -1));
        return result;
    }

    public boolean gte(T thisValue, T isGreaterThanThis) {
        boolean result = this.compute(this.accept.getComparator(), thisValue, isGreaterThanThis, com -> this.between.betweenInclusive(0, (Integer)com, 1));
        return result;
    }

    public boolean gt(T thisValue, T isGreaterThanEqualToThis) {
        boolean result = this.compute(this.accept.getComparator(), thisValue, isGreaterThanEqualToThis, com -> this.between.betweenInclusive(1, (Integer)com, 1));
        return result;
    }

    public boolean eq(T thisValue, T isEqualToThis) {
        boolean result = this.compute(this.accept.getComparator(), thisValue, isEqualToThis, com -> this.between.betweenInclusive(0, (Integer)com, 0));
        return result;
    }

    public static <T extends Comparable<T>> Compare<T> of() {
        return Compare.of(SnfComparator.AcceptNull.FALSE_ON_NULL);
    }

    public static <T extends Comparable<T>> Compare<T> of(SnfComparator.AcceptNull accept) {
        return new Compare<T>(accept);
    }
}

