/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.foundation.utility;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;

public class GfcDate
implements Serializable,
Cloneable,
Comparable {
    public static final int DAYS_IN_4_YEAR_CHUNK = 1461;
    public static final int BASE_YEAR = 1849;
    private static final int[] JULIAN_DAY = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365, 999};
    private static final int[] JULIAN_DAY_LEAP_YEAR = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366, 999};
    public static final int DAYS_BETWEEN_1849_AND_1900 = 18627;
    private static final int DAYS_BETWEEN_1849_AND_1970 = 44194;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private transient long javaDateMillis;
    private GfcDateState gfcState;

    public GfcDate() {
        this.gfcState = new GfcDateValidated(0, 0, 0, 0, "", false);
    }

    public GfcDate(int year, int month, int day) {
        this.gfcState = new GfcDateMDYInitialized(month, day, year);
    }

    public GfcDate(String strDate) {
        this.gfcState = new GfcDateStringInitialized(strDate);
    }

    public GfcDate(Date date) {
        this(date.getTime());
    }

    public GfcDate(long milliseconds) {
        this.javaDateMillis = milliseconds;
        this.gfcState = new GfcDateElapsedInitialized((int)(this.javaDateMillis / 86400000L + 44194L));
    }

    public GfcDate(int elapsedDays) {
        this.gfcState = new GfcDateElapsedInitialized(elapsedDays);
    }

    protected GfcDate(int year, int month, int day, int elapsed, String strDate, boolean valid) {
        this.gfcState = new GfcDateValidated(year, month, day, elapsed, strDate, valid);
    }

    public static GfcDate now() {
        return new GfcDate(System.currentTimeMillis());
    }

    public static GfcDate unknown() {
        return new GfcDate(0, 0, 0, 0, "", false);
    }

    protected void setGfcState(GfcDateState gfcState) {
        this.gfcState = gfcState;
    }

    public String toString() {
        return this.gfcState.toString(this);
    }

    public boolean isValid() {
        return this.gfcState.isValid(this);
    }

    public int hashCode() {
        return this.gfcState.getElapsedDays(this);
    }

    public int compareTo(Object anotherDate) throws IllegalArgumentException {
        int diff = 0;
        if (anotherDate == null) {
            diff = 1;
        } else if (anotherDate instanceof GfcDate) {
            diff = this.compareTo((GfcDate)anotherDate);
        } else if (anotherDate instanceof Date) {
            diff = this.compareTo((Date)anotherDate);
        } else {
            throw new IllegalArgumentException("compareTo can not compare object of type: " + anotherDate.getClass().getName());
        }
        return diff;
    }

    public final int compareTo(Date anotherDate) {
        int diff;
        if (anotherDate == null) {
            diff = 1;
        } else {
            diff = (int)(this.getTime() - anotherDate.getTime());
            if (diff < 0 && (long)diff + 86400000L >= 0L) {
                diff = 0;
            }
        }
        return diff;
    }

    public final int compareTo(GfcDate anotherDate) {
        return anotherDate == null ? 1 : this.gfcState.getElapsedDays(this) - anotherDate.getElapsedDays();
    }

    public boolean containedWithin(GfcDate startDate, GfcDate endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        int myElapsedDays = this.gfcState.getElapsedDays(this);
        return myElapsedDays >= startDate.getElapsedDays() && myElapsedDays <= endDate.getElapsedDays();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public boolean equalsOrAfter(GfcDate otherDate) {
        return this.compareTo(otherDate) >= 0;
    }

    public boolean equalsOrBefore(GfcDate otherDate) {
        return this.compareTo(otherDate) <= 0;
    }

    public boolean after(GfcDate otherDate) {
        return this.compareTo(otherDate) > 0;
    }

    public boolean before(GfcDate otherDate) {
        return this.compareTo(otherDate) < 0;
    }

    public boolean after(Date otherDate) {
        return this.compareTo(otherDate) > 0;
    }

    public boolean before(Date otherDate) {
        return this.compareTo(otherDate) < 0;
    }

    public int getElapsedDays() {
        return this.gfcState.getElapsedDays(this);
    }

    public long getTime() {
        if (this.javaDateMillis == 0L) {
            long adjustedElapsed = this.gfcState.getElapsedDays(this) - 44194;
            this.javaDateMillis = adjustedElapsed * 86400000L;
            this.javaDateMillis -= (long)TimeZone.getDefault().getRawOffset();
        }
        return this.javaDateMillis;
    }

    public Date getDate() {
        return new Date(this.getTime());
    }

    public void setDay(int day) {
        this.gfcState.setDay(this, day);
    }

    public int getDay() {
        return this.gfcState.getDay(this);
    }

    public void setMonth(int month) {
        this.gfcState.setMonth(this, month);
    }

    public int getMonth() {
        return this.gfcState.getMonth(this);
    }

    public void setYear(int year) {
        this.gfcState.setYear(this, year);
    }

    public int getYear() {
        return this.gfcState.getYear(this);
    }

    public GfcDate clone() throws CloneNotSupportedException {
        return new GfcDate(this.getYear(), this.getMonth(), this.getDay(), this.getElapsedDays(), this.toString(), this.isValid());
    }

    public final boolean isLeapYear(int year) {
        return year % 4 == 0 && year != 1900 && year != 2100 && year != 2200 && year != 2300;
    }

    private GfcDateState decodeDateAsState(String strDate) {
        int[] dayArray;
        int year = 0;
        int month = 0;
        int day = 0;
        int elapsedDays = 0;
        if (strDate == null) {
            return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
        }
        if ((strDate = strDate.trim()).length() != 8) {
            return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
        }
        try {
            year = Integer.parseInt(strDate.substring(0, 4));
            month = Integer.parseInt(strDate.substring(4, 6));
            if (month <= 0 || month > 12) {
                return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
            }
            day = Integer.parseInt(strDate.substring(6));
            dayArray = this.isLeapYear(year) ? JULIAN_DAY_LEAP_YEAR : JULIAN_DAY;
            int maxDayPerMonth = dayArray[month] - dayArray[month - 1];
            if (day <= 0 || day > maxDayPerMonth) {
                return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
            }
        }
        catch (NumberFormatException exc) {
            return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
        }
        if (year >= 1849) {
            int jul = dayArray[month - 1] + day;
            if (jul <= dayArray[month]) {
                elapsedDays = (year - 1849) * 1461 / 4 + jul - 1;
                if (year > 1900) {
                    --elapsedDays;
                }
            }
        } else {
            return new GfcDateValidated(year, month, day, elapsedDays, strDate, false);
        }
        return new GfcDateValidated(year, month, day, elapsedDays, strDate, true);
    }

    private GfcDateState calcMDYAsState(int elapsedDays) {
        int month = 0;
        int day = 0;
        int year = elapsedDays / 1461 * 4;
        int remainingDays = elapsedDays % 1461;
        if (remainingDays >= 1095) {
            year += 3;
        } else if (remainingDays >= 730) {
            year += 2;
        } else if (remainingDays >= 365) {
            ++year;
        }
        remainingDays = elapsedDays - year * 1461 / 4 + 1;
        if ((year += 1849) > 1900) {
            ++remainingDays;
        }
        int[] dayArray = this.isLeapYear(year) ? JULIAN_DAY_LEAP_YEAR : JULIAN_DAY;
        for (int idx = dayArray.length - 1; idx >= 0; --idx) {
            if (remainingDays <= dayArray[idx]) continue;
            month = idx + 1;
            if (month > 12) {
                month = 1;
                ++year;
            }
            day = remainingDays - dayArray[idx];
            break;
        }
        return new GfcDateValidated(year, month, day, elapsedDays, null, true);
    }

    private GfcDateState calcElapsedAsState(int month, int day, int year) {
        int elapsedDays = 0;
        boolean valid = true;
        if (month > 0 && month <= 12) {
            int[] daysMax;
            int[] nArray = daysMax = this.isLeapYear(year) ? JULIAN_DAY_LEAP_YEAR : JULIAN_DAY;
            if (day <= daysMax[month] - daysMax[month - 1]) {
                int adjustedYear = year - 1849;
                elapsedDays = adjustedYear / 4 * 1461 + adjustedYear % 4 * 365;
                if (year > 1900) {
                    --elapsedDays;
                }
                elapsedDays += daysMax[month - 1] + day - 1;
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return new GfcDateValidated(year, month, day, elapsedDays, null, valid);
    }

    public GfcDate minusDays(int days) {
        return new GfcDate(this.getElapsedDays() - days);
    }

    public GfcDate addDays(int days) {
        return new GfcDate(this.getElapsedDays() + days);
    }

    class GfcDateMDYInitialized
    implements GfcDateState {
        private int month;
        private int day;
        private int year;
        private String strDate;

        public GfcDateMDYInitialized(int month, int day, int year) {
            this.month = month;
            this.day = day;
            this.year = year;
        }

        @Override
        public String toString(GfcDate gfcDate) {
            if (this.strDate == null) {
                this.strDate = String.format("%04d%02d%02d", this.year, this.month, this.day);
            }
            return this.strDate;
        }

        @Override
        public int hashCode(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcElapsedAsState(this.month, this.day, this.year);
            gfcDate.setGfcState(state);
            return state.hashCode(gfcDate);
        }

        @Override
        public int compareTo(GfcDate gfcDate, GfcDate anotherDate) {
            GfcDateState state = gfcDate.calcElapsedAsState(this.month, this.day, this.year);
            gfcDate.setGfcState(state);
            return gfcDate.compareTo(anotherDate);
        }

        @Override
        public int getElapsedDays(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcElapsedAsState(this.month, this.day, this.year);
            gfcDate.setGfcState(state);
            return gfcDate.getElapsedDays();
        }

        @Override
        public void setDay(GfcDate gfcDate, int day) {
            this.day = day;
        }

        @Override
        public int getDay(GfcDate gfcDate) {
            return this.day;
        }

        @Override
        public void setMonth(GfcDate gfcDate, int month) {
            this.month = month;
        }

        @Override
        public int getMonth(GfcDate gfcDate) {
            return this.month;
        }

        @Override
        public void setYear(GfcDate gfcDate, int year) {
            this.year = year;
        }

        @Override
        public int getYear(GfcDate gfcDate) {
            return this.year;
        }

        @Override
        public boolean isValid(GfcDate gfcDate) {
            if (this.month <= 0 || this.month > 12 || this.year <= 0 || this.day <= 0) {
                return false;
            }
            int[] days = gfcDate.isLeapYear(this.year) ? JULIAN_DAY_LEAP_YEAR : JULIAN_DAY;
            return this.day <= days[this.month] - days[this.month - 1];
        }
    }

    class GfcDateElapsedInitialized
    implements GfcDateState {
        private final int elapsedDays;
        private final boolean valid;

        public GfcDateElapsedInitialized(int elapsedDays) {
            this.elapsedDays = elapsedDays;
            this.valid = this.elapsedDays >= 0;
        }

        @Override
        public String toString(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcMDYAsState(this.elapsedDays);
            gfcDate.setGfcState(state);
            return state.toString(gfcDate);
        }

        @Override
        public int hashCode(GfcDate gfcDate) {
            return this.elapsedDays;
        }

        @Override
        public int compareTo(GfcDate gfcDate, GfcDate anotherDate) {
            return this.elapsedDays - anotherDate.getElapsedDays();
        }

        @Override
        public int getElapsedDays(GfcDate gfcDate) {
            return this.elapsedDays;
        }

        @Override
        public void setDay(GfcDate gfcDate, int day) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(0, day, 0));
        }

        @Override
        public int getDay(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcMDYAsState(this.elapsedDays);
            gfcDate.setGfcState(state);
            return state.getDay(gfcDate);
        }

        @Override
        public void setMonth(GfcDate gfcDate, int month) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(month, 0, 0));
        }

        @Override
        public int getMonth(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcMDYAsState(this.elapsedDays);
            gfcDate.setGfcState(state);
            return state.getMonth(gfcDate);
        }

        @Override
        public void setYear(GfcDate gfcDate, int year) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(0, 0, year));
        }

        @Override
        public int getYear(GfcDate gfcDate) {
            GfcDateState state = gfcDate.calcMDYAsState(this.elapsedDays);
            gfcDate.setGfcState(state);
            return state.getYear(gfcDate);
        }

        @Override
        public boolean isValid(GfcDate gfcDate) {
            return this.valid;
        }
    }

    class GfcDateStringInitialized
    implements GfcDateState {
        private String strDate;

        public GfcDateStringInitialized(String strDate) {
            this.strDate = strDate;
        }

        @Override
        public String toString(GfcDate gfcDate) {
            return this.strDate;
        }

        @Override
        public int hashCode(GfcDate gfcDate) {
            return this.strDate == null ? 0 : this.strDate.hashCode();
        }

        @Override
        public int compareTo(GfcDate gfcDate, GfcDate anotherDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.compareTo(gfcDate, anotherDate);
        }

        @Override
        public int getElapsedDays(GfcDate gfcDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.getElapsedDays(gfcDate);
        }

        @Override
        public void setDay(GfcDate gfcDate, int day) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(0, day, 0));
        }

        @Override
        public int getDay(GfcDate gfcDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.getDay(gfcDate);
        }

        @Override
        public void setMonth(GfcDate gfcDate, int month) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(month, 0, 0));
        }

        @Override
        public int getMonth(GfcDate gfcDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.getMonth(gfcDate);
        }

        @Override
        public void setYear(GfcDate gfcDate, int year) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(0, 0, year));
        }

        @Override
        public int getYear(GfcDate gfcDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.getYear(gfcDate);
        }

        @Override
        public boolean isValid(GfcDate gfcDate) {
            GfcDateState state = gfcDate.decodeDateAsState(this.strDate);
            gfcDate.setGfcState(state);
            return state.isValid(gfcDate);
        }
    }

    class GfcDateValidated
    implements GfcDateState {
        private int year;
        private int month;
        private int day;
        private int elapsedDays;
        private String strDate;
        private boolean valid;

        public GfcDateValidated(int year, int month, int day, int elapsedDays, String strDate, boolean valid) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.elapsedDays = elapsedDays;
            this.strDate = strDate;
            this.valid = valid;
        }

        @Override
        public String toString(GfcDate gfcDate) {
            if (this.strDate == null) {
                this.strDate = String.format("%04d%02d%02d", this.year, this.month, this.day);
            }
            return this.strDate;
        }

        @Override
        public int hashCode(GfcDate gfcDate) {
            return this.elapsedDays;
        }

        @Override
        public int compareTo(GfcDate gfcDate, GfcDate anotherDate) {
            return anotherDate == null ? 1 : this.elapsedDays - anotherDate.getElapsedDays();
        }

        @Override
        public int getElapsedDays(GfcDate gfcDate) {
            return this.elapsedDays;
        }

        @Override
        public void setDay(GfcDate gfcDate, int day) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(this.month, day, this.year));
        }

        @Override
        public int getDay(GfcDate gfcDate) {
            return this.day;
        }

        @Override
        public void setMonth(GfcDate gfcDate, int month) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(month, this.day, this.year));
        }

        @Override
        public int getMonth(GfcDate gfcDate) {
            return this.month;
        }

        @Override
        public void setYear(GfcDate gfcDate, int year) {
            gfcDate.setGfcState(new GfcDateMDYInitialized(this.month, this.day, year));
        }

        @Override
        public int getYear(GfcDate gfcDate) {
            return this.year;
        }

        @Override
        public boolean isValid(GfcDate gfcDate) {
            return this.valid;
        }
    }

    static interface GfcDateState
    extends Serializable {
        public String toString(GfcDate var1);

        public int hashCode(GfcDate var1);

        public int compareTo(GfcDate var1, GfcDate var2);

        public int getElapsedDays(GfcDate var1);

        @Deprecated
        public void setDay(GfcDate var1, int var2);

        public int getDay(GfcDate var1);

        @Deprecated
        public void setMonth(GfcDate var1, int var2);

        public int getMonth(GfcDate var1);

        @Deprecated
        public void setYear(GfcDate var1, int var2);

        public int getYear(GfcDate var1);

        public boolean isValid(GfcDate var1);
    }
}

