/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.foundation.utility;

import com.mmm.his.cer.foundation.utility.GfcDate;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleGfcDateFormat {
    private final Format simpleDateFormat;
    private boolean builtInFormat;
    private String pattern;

    public SimpleGfcDateFormat() {
        this("yyyyMMdd");
    }

    public SimpleGfcDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public SimpleGfcDateFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        if ("YYYYMMDD".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new YYYYMMDD_Format();
            this.builtInFormat = true;
        } else if ("DDMMYYYY".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new DDMMYYY_Format();
            this.builtInFormat = true;
        } else if ("MMDDYYYY".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new MMDDYYY_Format();
            this.builtInFormat = true;
        } else {
            this.simpleDateFormat = new SimpleDateFormat(pattern, locale);
        }
    }

    public SimpleGfcDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        this.pattern = pattern;
        if ("YYYYMMDD".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new YYYYMMDD_Format();
            this.builtInFormat = true;
        } else if ("DDMMYYYY".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new DDMMYYY_Format();
            this.builtInFormat = true;
        } else if ("MMDDYYYY".equalsIgnoreCase(pattern)) {
            this.simpleDateFormat = new MMDDYYY_Format();
            this.builtInFormat = true;
        } else {
            this.simpleDateFormat = new SimpleDateFormat(pattern, formatSymbols);
        }
    }

    public SimpleGfcDateFormat(int dateStyle, Locale locale) {
        this.pattern = Integer.toString(dateStyle);
        this.simpleDateFormat = DateFormat.getDateInstance(dateStyle, locale);
    }

    public String format(GfcDate date) {
        return this.builtInFormat ? this.simpleDateFormat.format(date) : this.simpleDateFormat.format(date.getDate());
    }

    public GfcDate parse(String source) throws ParseException {
        GfcDate gfcDate;
        Object obj = this.simpleDateFormat.parseObject(source);
        if (obj instanceof Date) {
            Date date = (Date)obj;
            gfcDate = new GfcDate(date);
        } else if (obj instanceof GfcDate) {
            gfcDate = (GfcDate)obj;
        } else {
            throw new ParseException("Can not handle converted class of type '" + obj.getClass().getName() + "'", 0);
        }
        return gfcDate;
    }

    public String toPattern() {
        return this.pattern;
    }

    class DDMMYYY_Format
    extends Format {
        private static final long serialVersionUID = 1L;
        public static final String PATTERN = "DDMMYYYY";

        DDMMYYY_Format() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            GfcDate gfcDate = (GfcDate)obj;
            if (gfcDate.getDay() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getDay());
            if (gfcDate.getMonth() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getMonth());
            toAppendTo.append(gfcDate.getYear());
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int parsePos = pos.getIndex();
            int day = Integer.parseInt(source.substring(parsePos, parsePos + 2));
            int month = Integer.parseInt(source.substring(parsePos += 2, parsePos + 2));
            int year = Integer.parseInt(source.substring(parsePos += 2, parsePos + 4));
            pos.setIndex(parsePos += 4);
            return new GfcDate(year, month, day);
        }
    }

    class MMDDYYY_Format
    extends Format {
        private static final long serialVersionUID = 1L;
        public static final String PATTERN = "MMDDYYYY";

        MMDDYYY_Format() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            GfcDate gfcDate = (GfcDate)obj;
            if (gfcDate.getMonth() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getMonth());
            if (gfcDate.getDay() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getDay());
            toAppendTo.append(gfcDate.getYear());
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int parsePos = pos.getIndex();
            int month = Integer.parseInt(source.substring(parsePos, parsePos + 2));
            int day = Integer.parseInt(source.substring(parsePos += 2, parsePos + 2));
            int year = Integer.parseInt(source.substring(parsePos += 2, parsePos + 4));
            pos.setIndex(parsePos += 4);
            return new GfcDate(year, month, day);
        }
    }

    class YYYYMMDD_Format
    extends Format {
        private static final long serialVersionUID = 1L;
        public static final String PATTERN = "YYYYMMDD";

        YYYYMMDD_Format() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            GfcDate gfcDate = (GfcDate)obj;
            toAppendTo.append(gfcDate.getYear());
            if (gfcDate.getMonth() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getMonth());
            if (gfcDate.getDay() < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(gfcDate.getDay());
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            int parsePos = pos.getIndex();
            int year = Integer.parseInt(source.substring(parsePos, parsePos + 4));
            int month = Integer.parseInt(source.substring(parsePos += 4, parsePos + 2));
            int day = Integer.parseInt(source.substring(parsePos += 2, parsePos + 2));
            pos.setIndex(parsePos += 2);
            return new GfcDate(year, month, day);
        }
    }
}

