/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.app;

import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.component.v100.SnfComponent;
import gov.cms.grouper.snf.lego.BlockWithException;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.SnfError;
import gov.cms.grouper.snf.model.SnfProcessError;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.model.table.SnfVersionRow;
import gov.cms.grouper.snf.process.SnfValidations;
import gov.cms.grouper.snf.transfer.SnfClaim;
import gov.cms.grouper.snf.util.reader.SnfDataMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdpm {
    public static final Logger log = LoggerFactory.getLogger(Pdpm.class);
    private final SnfDataMapper mapper = new SnfDataMapper();
    private final List<String> errorLines;

    public Pdpm() {
        this(new ArrayList<String>());
    }

    public SnfClaim exec(String line) {
        SnfClaim claim = this.transformToClaim(line);
        return this.process(claim);
    }

    public SnfClaim exec(SnfClaim claim) {
        return this.process(claim);
    }

    public List<SnfClaim> exec(File snfFile) {
        return this.processFile(snfFile, line -> {
            SnfClaim claim = this.exec((String)line);
            return claim;
        });
    }

    public String getClaimFixedString(SnfClaim snfClaim) {
        return this.mapper.mapClaimToMds(snfClaim, Rai300.values());
    }

    protected Pdpm(List<String> errorLines) {
        this.errorLines = errorLines;
    }

    protected SnfClaim process(SnfClaim claim) {
        this.tryExec(claim.getOriginalRecord(), () -> {
            Integer ver = this.getVersion(claim.getAssessmentReferenceDate());
            if (ver == null) {
                claim.addErrors(SnfError.INVALID_ASSESSMENT_REFERENCE_DATE.getReason(new String[0]));
            } else if (ver != 0) {
                try (SnfComponent snfComponent = new SnfComponent(ver);){
                    snfComponent.exec(claim);
                }
            }
        });
        return claim;
    }

    protected <T> List<T> processFile(File file, Function<String, T> lineExec) {
        ArrayList<T> results = new ArrayList<T>(1000);
        try (final Scanner sc = new Scanner(file, "UTF-8");){
            Thread closeFileThread = new Thread(){

                @Override
                public void run() {
                    log.debug("closing files");
                    SnfUtils.tryIgnoreExcption(() -> Pdpm.this.closeFile(sc));
                }
            };
            Runtime.getRuntime().addShutdownHook(closeFileThread);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (sc.ioException() != null) {
                    throw sc.ioException();
                }
                T item = lineExec.apply(line);
                results.add(item);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return results;
    }

    private void closeFile(Scanner sc) {
        sc.close();
    }

    protected Integer getVersion(LocalDate ard) {
        Integer version = null;
        for (Map.Entry<Integer, SnfVersionRow> row : SnfTables.versions.entrySet()) {
            if (!SnfComparator.betweenInclusive(row.getValue().getFrom(), ard, row.getValue().getTo())) continue;
            version = row.getKey();
            break;
        }
        return version;
    }

    protected SnfClaim transformToClaim(String line) {
        SnfClaim claim = this.mapper.mapMdsToClaim(line, Rai300.values());
        return claim;
    }

    protected void tryExec(String line, BlockWithException ex) {
        try {
            ex.exec();
        }
        catch (Throwable th) {
            if (this.errorLines == null) {
                throw new RuntimeException(th);
            }
            this.errorLines.add(line);
        }
    }

    protected SnfClaim process(Integer version, SnfClaim claim) {
        return this.process(version, claim, null);
    }

    protected SnfClaim process(Integer version, SnfClaim claim, Consumer<SnfClaim> additionalPostProcessing) {
        this.tryExec(claim.getOriginalRecord(), () -> {
            Integer ver = version;
            if (version == null) {
                ver = this.getVersion(claim.getAssessmentReferenceDate());
            }
            if (ver == null) {
                claim.addErrors(SnfError.INVALID_ASSESSMENT_REFERENCE_DATE.getReason(new String[0]));
            } else if (ver != 0) {
                try (SnfComponent snfComponent = new SnfComponent(ver);){
                    snfComponent.exec(claim);
                }
                catch (SnfProcessError se) {
                    throw se;
                }
                catch (Throwable th) {
                    claim.addErrors(SnfError.PROCESS_ERROR.getReason(th.getMessage()));
                    throw th;
                }
            }
        });
        if (additionalPostProcessing != null) {
            additionalPostProcessing.accept(claim);
        }
        return claim;
    }

    protected SnfClaim exec(Integer version, String line, Consumer<SnfClaim> additionalPostProcessing) {
        SnfClaim claim = this.transformToClaim(line);
        this.execClaim(version, claim, additionalPostProcessing);
        return claim;
    }

    protected List<SnfClaim> exec(Integer version, List<String> lines, Consumer<SnfClaim> additionalPostProcessing) {
        ArrayList<SnfClaim> results = new ArrayList<SnfClaim>(lines.size());
        for (String line : lines) {
            SnfClaim claim = this.exec(version, line, additionalPostProcessing);
            results.add(claim);
        }
        return results;
    }

    protected List<SnfClaim> exec(Integer version, List<String> lines) {
        return this.exec(version, lines, null);
    }

    protected SnfClaim exec(Integer version, String line) {
        return this.exec(version, line, null);
    }

    protected List<SnfClaim> exec(Integer version, Path path) throws IOException {
        List<SnfClaim> results = this.processFile(version, path, line -> {
            SnfClaim claim = this.exec(version, (String)line, null);
            return claim;
        });
        return results;
    }

    protected List<SnfClaim> exec(Integer version, Path path, Consumer<SnfClaim> additionalPostProcessing) {
        List<SnfClaim> claims = this.processFile(version, path, line -> {
            SnfClaim claim = this.exec(version, (String)line, additionalPostProcessing);
            return claim;
        });
        return claims;
    }

    protected SnfClaim execClaim(Integer version, SnfClaim claim) {
        return this.execClaim(version, claim, null);
    }

    protected SnfClaim execClaim(Integer version, SnfClaim claim, Consumer<SnfClaim> additionalPostProcessing) {
        this.validate(claim);
        this.process(version, claim, additionalPostProcessing);
        return claim;
    }

    protected <T> List<T> processFile(Integer version, Path path, Function<String, T> lineExec) {
        ArrayList<T> results = new ArrayList<T>(1000);
        try (final Scanner sc = new Scanner(path, "UTF-8");){
            Thread closeFileThread = new Thread(){

                @Override
                public void run() {
                    log.debug("closing files");
                    SnfUtils.tryIgnoreExcption(() -> Pdpm.this.closeFile(sc));
                }
            };
            Runtime.getRuntime().addShutdownHook(closeFileThread);
            int counter = 1;
            while (sc.hasNextLine()) {
                if (counter % 10000 == 0) {
                    System.out.println("lines processed: " + counter);
                }
                String line = sc.nextLine();
                if (sc.ioException() != null) {
                    throw sc.ioException();
                }
                T item = lineExec.apply(line);
                results.add(item);
                ++counter;
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return results;
    }

    protected void validate(SnfClaim claim) {
        this.tryExec(claim.getOriginalRecord(), () -> SnfValidations.validateInputs(claim));
    }
}

