/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.component.v100.logic;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.component.v100.logic.nursing.BscpLogic;
import gov.cms.grouper.snf.component.v100.logic.nursing.ReducedPhysicalFunctionLogic;
import gov.cms.grouper.snf.component.v100.logic.nursing.SpecialCare;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.lego.SnfVersionImpl;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class NursingLogic
extends SnfVersionImpl<NursingCmg> {
    public static final List<Rai300> extensiveServices = Arrays.asList(Rai300.O0100E2, Rai300.O0100F2, Rai300.O0100M2);
    public static final Set<Rai300> skinTreatments = SnfUtils.toSet(Rai300.M1200C, Rai300.M1200D, Rai300.M1200E, Rai300.M1200G, Rai300.M1200H);
    public static final Set<Rai300> skinTreatments2 = SnfUtils.toSet(Rai300.M1200A, Rai300.M1200B);
    private final ClaimInfo claim;
    private final SpecialCare specialCare;
    private final ReducedPhysicalFunctionLogic physical;
    private final BscpLogic bscp;

    public NursingLogic(ClaimInfo claim, SpecialCare specialCare, ReducedPhysicalFunctionLogic physical, BscpLogic bscp) {
        super(claim.getVersion());
        this.claim = claim;
        this.specialCare = specialCare;
        this.physical = physical;
        this.bscp = bscp;
    }

    protected List<Rai300> getCodeServices() {
        List<Rai300> services = extensiveServices.stream().filter(item -> {
            boolean result = this.claim.isCheckedAndNotNull((Rai300)item);
            return result;
        }).collect(Collectors.toList());
        return services;
    }

    protected NursingCmg evaluateExtensiveServices() {
        List<Rai300> codedServices = this.getCodeServices();
        int nursingFunctionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (codedServices != null && !codedServices.isEmpty()) {
            result = nursingFunctionScore >= 15 ? this.specialCare.evaluateClinicallyComplex(true) : (codedServices.contains(Rai300.O0100E2) && codedServices.contains(Rai300.O0100F2) ? NursingCmg.ES3 : (codedServices.contains(Rai300.O0100E2) || codedServices.contains(Rai300.O0100F2) ? NursingCmg.ES2 : (codedServices.contains(Rai300.O0100M2) && !codedServices.contains(Rai300.O0100E2) && !codedServices.contains(Rai300.O0100F2) ? NursingCmg.ES1 : null)));
        }
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        NursingCmg cmg;
        block1: {
            SnfVersionImpl com;
            cmg = this.evaluateExtensiveServices();
            if (cmg != null) break block1;
            List<SnfVersionImpl> components = Arrays.asList(this.specialCare, this.bscp, this.physical);
            Iterator<SnfVersionImpl> iterator = components.iterator();
            while (iterator.hasNext() && (cmg = (NursingCmg)((Object)(com = iterator.next()).exec())) == null) {
            }
        }
        return SnfContext.trace(cmg);
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }

    public SpecialCare getSpecialCare() {
        return this.specialCare;
    }

    public ReducedPhysicalFunctionLogic getPhysical() {
        return this.physical;
    }

    public BscpLogic getBscp() {
        return this.bscp;
    }
}

