/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.transfer;

import com.mmm.his.cer.foundation.transfer.Claim;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SnfClaim
extends Claim
implements ISnfClaim {
    private static final long serialVersionUID = -6053717059913154415L;
    private int version;
    private String assessmentSystem;
    private LocalDate birthDate;
    private LocalDate admissionDate;
    private List<Assessment> assessments = new ArrayList<Assessment>();
    private LocalDate dischargeDate;
    private LocalDate assessmentReferenceDate;
    private Integer aiCode;
    private Integer obra;
    private String hippsCode;
    private List<String> errors = new ArrayList<String>();
    private String originalRecord;

    @Override
    public void setAssessmentSystem(String system) {
        this.assessmentSystem = system;
    }

    @Override
    public String getAssessmentSystem() {
        return this.assessmentSystem;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    @Override
    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    @Override
    public void setAdmissionDate(LocalDate admissionDate) {
        this.admissionDate = admissionDate;
    }

    @Override
    public LocalDate getAdmissionDate() {
        return this.admissionDate;
    }

    @Override
    public SnfDiagnosisCode getPrimaryDiagnosis() {
        return this.getCodes(SnfDiagnosisCode.class).stream().findFirst().orElse(null);
    }

    public void insertPrimaryDiagnosis(SnfDiagnosisCode pdx) {
        this.codes.add(0, pdx);
    }

    @Override
    public void setPrimaryDiagnosis(SnfDiagnosisCode pdx) {
        if (this.codes.size() == 0) {
            this.codes.add(pdx);
        } else {
            this.codes.set(0, pdx);
        }
    }

    @Override
    public List<SnfDiagnosisCode> getSecondaryDiagnoses() {
        return this.getCodes(SnfDiagnosisCode.class).stream().skip(1L).collect(Collectors.toList());
    }

    @Override
    public void addAssessment(Assessment assessment) {
        this.assessments.add(assessment);
    }

    @Override
    public List<Assessment> getAssessments() {
        return this.assessments;
    }

    @Override
    public void setDischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Override
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    public void setAssessmentReferenceDate(LocalDate assessmentReferenceDate) {
        this.assessmentReferenceDate = assessmentReferenceDate;
    }

    public LocalDate getAssessmentReferenceDate() {
        return this.assessmentReferenceDate;
    }

    public void setAssessments(List<Assessment> assessments) {
        this.assessments = assessments;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrors(String error) {
        this.errors.add(error);
    }

    @Override
    public boolean hasError() {
        return this.errors.size() > 0;
    }

    @Override
    public String getHippsCode() {
        return this.hippsCode;
    }

    @Override
    public void setHippsCode(String code) {
        this.hippsCode = code;
    }

    @Override
    public String getOriginalRecord() {
        return this.originalRecord;
    }

    @Override
    public void setOriginalRecord(String originalRecord) {
        this.originalRecord = originalRecord;
    }

    @Override
    public Integer getAiCode() {
        return this.aiCode;
    }

    @Override
    public void setAiCode(Integer code) {
        this.aiCode = code;
    }

    @Override
    public Integer getObra() {
        return this.obra;
    }

    @Override
    public void setObra(Integer obra) {
        this.obra = obra;
    }

    public String toString() {
        return "SnfClaim{version=" + this.version + ", assessmentSystem='" + this.assessmentSystem + '\'' + ", birthDate=" + this.birthDate + ", admissionDate=" + this.admissionDate + ", assessments=" + this.assessments + ", dischargeDate=" + this.dischargeDate + ", assessmentReferenceDate=" + this.assessmentReferenceDate + ", aiCode=" + this.aiCode + ", obra=" + this.obra + ", hippsCode='" + this.hippsCode + '\'' + ", errors=" + this.errors + ", originalRecord='" + this.originalRecord + '\'' + ", codes=" + this.codes + '}';
    }
}

