/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.util;

import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.component.v100.logic.nursing.Const;
import gov.cms.grouper.snf.lego.SnfCache;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.lego.TriFunction;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.model.table.BasicRow;
import gov.cms.grouper.snf.model.table.PerformanceRecodeRow;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ClaimInfo {
    private final int version;
    private final Map<String, Assessment> byName;
    private final Map<String, Assessment> byItem;
    private final boolean hasIpa;
    private final SnfCache.SupplierCache<Integer> functionScoreCache;

    public ClaimInfo(int version, boolean hasIpa, List<Assessment> assessments) {
        this.version = version;
        this.hasIpa = hasIpa;
        HashMap<String, Assessment> temp = new HashMap<String, Assessment>();
        HashMap<String, Assessment> temp2 = new HashMap<String, Assessment>();
        for (Assessment ast : assessments) {
            temp.put(ast.getName(), ast);
            temp2.put(ast.getItem(), ast);
        }
        this.byName = Collections.unmodifiableMap(temp);
        this.byItem = Collections.unmodifiableMap(temp2);
        this.functionScoreCache = SnfCache.of(() -> {
            Set<Rai300> bedMobility = Const.bedMobility.get(this.hasIpa());
            Set<Rai300> transfer = Const.transfer.get(this.hasIpa());
            Set<Rai300> eatToilet = Const.eatToilet.get(this.hasIpa());
            int score = this.calculateFunctionScore(Const.assessmentValueFunction, bedMobility, transfer, Collections.emptySet(), eatToilet);
            return score;
        });
    }

    public static ClaimInfo of(int version, boolean ipa, List<Assessment> assessments) {
        return new ClaimInfo(version, ipa, assessments);
    }

    public boolean hasIpa() {
        return this.hasIpa;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAssessmentValue(Rai300 field, int nullValue) {
        Assessment foundAssessment = this.byItem.get(field.name());
        int result = SnfUtils.nullCheck2(foundAssessment, () -> nullValue, () -> foundAssessment.getValueInt());
        return result;
    }

    public int getAssessmentValue(Rai300 field) {
        return this.getAssessmentValue(field, Integer.MIN_VALUE);
    }

    public Assessment getAssessment(Rai300 field) {
        return this.byItem.get(field.name());
    }

    public boolean isAnyAssessmentValuesPresent(Set<Rai300> rai300s) {
        boolean result = rai300s.stream().map(Enum::name).anyMatch(name -> {
            boolean rs = this.byItem.containsKey(name) && this.byItem.get(name).isCheck();
            return rs;
        });
        return result;
    }

    public boolean isAnyAssessmentValuesGreaterThanN(Set<Rai300> rai300s, int n) {
        boolean result = rai300s.stream().map(Enum::name).anyMatch(name -> {
            boolean rs = this.byItem.containsKey(name) && this.byItem.get(name).getValueInt() > n;
            return rs;
        });
        return result;
    }

    public Boolean isCheckedAndNotNull(Rai300 rai300) {
        boolean result = this.isAnyAssessmentValuesPresent(SnfUtils.toSet(rai300));
        return result;
    }

    public int countAssessmentPresent(Set<Rai300> rai300s) {
        int result = (int)rai300s.stream().map(Enum::name).filter(name -> {
            boolean rs = this.byItem.get(name) != null && this.byItem.get(name).isCheck();
            return rs;
        }).count();
        return result;
    }

    public Set<String> getNtaCategories(List<SnfDiagnosisCode> codes) {
        return codes.stream().map(SnfDiagnosisCode::getNtaCategory).collect(Collectors.toSet());
    }

    public boolean hasAssessmentOf(Rai300 field, Predicate<Assessment> condition) {
        Assessment ast = this.byItem.get(field.name());
        boolean result = SnfUtils.nullCheck2(ast, () -> false, () -> condition.test(ast));
        return result;
    }

    public boolean isClassifiedBehavioralSymptomsCognitivePerformance(Supplier<Integer> b0700Supplier, Supplier<Integer> c0700Supplier, Supplier<Integer> c1000Supplier, Supplier<Boolean> isComaAndNoActivities) {
        int b0700 = b0700Supplier.get();
        int c0700 = c0700Supplier.get();
        int c1000 = c1000Supplier.get();
        return SnfUtils.meetFirstNConditions(Arrays.asList(SnfUtils.of(b0700 > 0), SnfUtils.of(c0700 == 1), SnfUtils.of(c1000 > 0)), 2) && (b0700 >= 2 || c1000 >= 2) || c1000 == 3 || isComaAndNoActivities.get() != false;
    }

    public int performanceRecode(Supplier<Integer> score) {
        PerformanceRecodeRow row = SnfTables.get(SnfTables.performanceRecodeTable, score.get(), BasicRow.getVersionSelector(), this.version);
        if (row != null) {
            return row.getFunctionScore();
        }
        return 0;
    }

    public int getFunctionScore() {
        return this.functionScoreCache.get();
    }

    protected int calculateFunctionScore(TriFunction<Integer, ClaimInfo, String, Integer> functionalAssessments, Set<Rai300> bedMobilityList, Set<Rai300> transferList, Set<Rai300> walkingList, Set<Rai300> generalItemList) {
        Predicate<Rai300> predicate = rai -> this.getAssessment((Rai300)rai) != null && this.getAssessment((Rai300)rai).getValueInt() != Integer.MIN_VALUE;
        bedMobilityList = bedMobilityList.stream().filter(predicate).collect(Collectors.toSet());
        transferList = transferList.stream().filter(predicate).collect(Collectors.toSet());
        walkingList = walkingList.stream().filter(predicate).collect(Collectors.toSet());
        generalItemList = generalItemList.stream().filter(predicate).collect(Collectors.toSet());
        return this.calculateFunctionScoreString(functionalAssessments, ClaimInfo.getString(bedMobilityList), ClaimInfo.getString(transferList), ClaimInfo.getString(walkingList), ClaimInfo.getString(generalItemList));
    }

    public int calculateFunctionScoreString(TriFunction<Integer, ClaimInfo, String, Integer> functionalAssessments, List<String> bedMobilityList, List<String> transferList, List<String> walkingList, List<String> generalItemList) {
        int scale = 3;
        List beds = bedMobilityList.stream().map(item -> (Integer)functionalAssessments.apply(this.version, this, (String)item)).collect(Collectors.toList());
        BigDecimal bedSum = SnfComparator.sum(beds);
        BigDecimal avgBedMobility = bedSum.divide(new BigDecimal(2), 3, RoundingMode.HALF_UP);
        List transfer = transferList.stream().map(item -> (Integer)functionalAssessments.apply(this.version, this, (String)item)).collect(Collectors.toList());
        BigDecimal transferSum = SnfComparator.sum(transfer);
        BigDecimal avgTransfer = transferSum.divide(new BigDecimal(3), 3, RoundingMode.HALF_UP);
        List walking = walkingList.stream().map(item -> (Integer)functionalAssessments.apply(this.version, this, (String)item)).collect(Collectors.toList());
        BigDecimal walkingSum = SnfComparator.sum(walking);
        BigDecimal avgWalking = walkingSum.divide(new BigDecimal(2), 3, RoundingMode.HALF_UP);
        List generalItemValues = generalItemList.stream().map(item -> (Integer)functionalAssessments.apply(this.version, this, (String)item)).collect(Collectors.toList());
        BigDecimal result = SnfComparator.sum(generalItemValues).add(avgBedMobility).add(avgTransfer).add(avgWalking);
        result = result.setScale(0, RoundingMode.HALF_UP);
        return result.intValue();
    }

    public boolean isComaAndNoActivities(Supplier<Integer> b0100Supplier) {
        int b0100 = b0100Supplier.get();
        HashSet activitySet = new HashSet(Const.bedMobility.get(this.hasIpa()));
        activitySet.addAll(Const.transfer.get(this.hasIpa()));
        activitySet.addAll(Const.eatToilet.get(this.hasIpa()));
        List<Integer> activitiesCheck = Arrays.asList(1, 9, 88);
        boolean isDependentOrNoActivityOccurred = activitySet.stream().allMatch(item -> {
            int value = this.getAssessmentValue((Rai300)item);
            return activitiesCheck.contains(value);
        });
        return b0100 == 1 && isDependentOrNoActivityOccurred;
    }

    public static List<String> getString(Collection<Rai300> items) {
        List<String> result = items.stream().map(rai -> rai.name()).collect(Collectors.toList());
        return result;
    }

    public Set<String> getAssessmentNames() {
        return this.getAssessmentNames(null);
    }

    public Set<String> getAssessmentNames(Predicate<Assessment> checkedAssessment) {
        if (checkedAssessment == null) {
            checkedAssessment = ast -> Boolean.TRUE;
        }
        return this.byName.values().stream().filter(checkedAssessment).map(Assessment::getName).collect(Collectors.toSet());
    }

    public Set<Assessment> getAssessments() {
        return SnfUtils.toSet(this.byItem.values());
    }
}

