package gov.cms.grouper.snf.transfer;

import com.mmm.his.cer.foundation.model.ICodeList;
import com.mmm.his.cer.foundation.transfer.IClaim;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import java.time.LocalDate;
import java.util.List;

/**
 * Defines the SNF claim.
 */
public interface ISnfClaim extends IClaim, ICodeList {
  // INPUTS

  void setAssessmentSystem(String system);

  String getAssessmentSystem();

  void setVersion(int version);

  int getVersion();

  void setBirthDate(LocalDate birthDate);

  LocalDate getBirthDate();

  void setAdmissionDate(LocalDate admissionDate);

  LocalDate getAdmissionDate();

  Integer getAiCode();

  void setAiCode(Integer code);

  Integer getObra();

  void setObra(Integer obra);

  SnfDiagnosisCode getPrimaryDiagnosis();

  void setPrimaryDiagnosis(SnfDiagnosisCode pdx);

  List<SnfDiagnosisCode> getSecondaryDiagnoses();
  void addAssessment(Assessment assessment);

  List<Assessment> getAssessments();

  void setDischargeDate(LocalDate dischargeDate);

  LocalDate getDischargeDate();

  // OUTPUTS
  void addErrors(String error);

  List<String> getErrors();

  boolean hasError();

  String getHippsCode();

  void setHippsCode(String code);

  String getOriginalRecord();

  void setOriginalRecord(String originalRecord);

}
