package gov.cms.grouper.snf.transfer;

import com.mmm.his.cer.foundation.transfer.Claim;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * The SNF record containing MDS inputs and outputs
 */
public class SnfClaim extends Claim implements ISnfClaim {

  /**
   *
   */
  private static final long serialVersionUID = -6053717059913154415L;

  // INPUTS
  private int version;
  private String assessmentSystem;
  private LocalDate birthDate;
  private LocalDate admissionDate;
  private List<Assessment> assessments = new ArrayList<>();
  private LocalDate dischargeDate;
  private LocalDate assessmentReferenceDate;
  private Integer aiCode;
  private Integer obra;

  // OUTPUTS
  private String hippsCode;

  private List<String> errors = new ArrayList<>();

  // Miscellaneous
  private String originalRecord;

  @Override
  public void setAssessmentSystem(String system) {
    this.assessmentSystem = system;
  }

  @Override
  public String getAssessmentSystem() {
    return this.assessmentSystem;
  }

  @Override
  public void setVersion(int version) {
    this.version = version;
  }

  @Override
  public int getVersion() {
    return this.version;
  }

  @Override
  public void setBirthDate(LocalDate birthDate) {
    this.birthDate = birthDate;
  }

  @Override
  public LocalDate getBirthDate() {
    return this.birthDate;
  }

  @Override
  public void setAdmissionDate(LocalDate admissionDate) {
    this.admissionDate = admissionDate;
  }

  @Override
  public LocalDate getAdmissionDate() {
    return this.admissionDate;
  }

  public SnfDiagnosisCode getPrimaryDiagnosis() {
    return this.getCodes(SnfDiagnosisCode.class).stream().findFirst().orElse(null);
  }

  public void insertPrimaryDiagnosis(SnfDiagnosisCode pdx) {
    this.codes.add(0, pdx);
  }

  public void setPrimaryDiagnosis(SnfDiagnosisCode pdx) {
    if (this.codes.size() == 0) {
      codes.add(pdx);
    } else {
      this.codes.set(0, pdx);
    }
  }

  public List<SnfDiagnosisCode> getSecondaryDiagnoses() {
    return this.getCodes(SnfDiagnosisCode.class).stream().skip(1).collect(Collectors.toList());
  }
  @Override
  public void addAssessment(Assessment assessment) {
    this.assessments.add(assessment);
  }

  @Override
  public List<Assessment> getAssessments() {
    return this.assessments;
  }

  @Override
  public void setDischargeDate(LocalDate dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @Override
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  public void setAssessmentReferenceDate(LocalDate assessmentReferenceDate) {
    this.assessmentReferenceDate = assessmentReferenceDate;
  }

  public LocalDate getAssessmentReferenceDate() {
    return this.assessmentReferenceDate;
  }

  public void setAssessments(List<Assessment> assessments) {
    this.assessments = assessments;
  }

  /**
   * return list of errors on the record
   */
  @Override
  public List<String> getErrors() {
    return this.errors;
  }

  @Override
  public void addErrors(String error) {
    this.errors.add(error);
  }

  /**
   * return true when unable to compute hipps else there are no errors
   * 
   */
  public boolean hasError() {
    return this.errors.size() > 0;
  }

  @Override
  public String getHippsCode() {
    return this.hippsCode;
  }

  @Override
  public void setHippsCode(String code) {
    this.hippsCode = code;
  }

  public String getOriginalRecord() {
    return this.originalRecord;
  }

  public void setOriginalRecord(String originalRecord) {
    this.originalRecord = originalRecord;
  }

  @Override
  public Integer getAiCode() {
    return this.aiCode;
  }

  @Override
  public void setAiCode(Integer code) {
    this.aiCode = code;
  }

  @Override
  public Integer getObra() {
    return this.obra;
  }

  @Override
  public void setObra(Integer obra) {
    this.obra = obra;
  }

  @Override
  public String toString() {
    return "SnfClaim{" +
        "version=" + version +
        ", assessmentSystem='" + assessmentSystem + '\'' +
        ", birthDate=" + birthDate +
        ", admissionDate=" + admissionDate +
        ", assessments=" + assessments +
        ", dischargeDate=" + dischargeDate +
        ", assessmentReferenceDate=" + assessmentReferenceDate +
        ", aiCode=" + aiCode +
        ", obra=" + obra +
        ", hippsCode='" + hippsCode + '\'' +
        ", errors=" + errors +
        ", originalRecord='" + originalRecord + '\'' +
        ", codes=" + codes +
        '}';
  }
}
