package gov.cms.grouper.snf.lego;

/**
 * Base implementation for each Logic class.
 *
 * @param <T> The data type that ultimately gets return by the Logic class. This can either be a CMG
 *        String, CognitivieLevel, etc.
 */
public abstract class SnfVersionImpl<T> {

  private final int version;

  public SnfVersionImpl(int version) {
    super();
    this.version = version;
  }

  public int getVersion() {
    return this.version;
  }

  public abstract T exec();

}
