package gov.cms.grouper.snf.model;

import gov.cms.grouper.snf.lego.SnfUtils;

public enum SnfError {
  INVALID_ASSESSMENT_REFERENCE_DATE("Assessment reference date is missing or is invalid: %s"),
  INVALID_A0310A_OR_A0310B("Invalid A0310A: %s or A0310B: %s"),
  INVALID_LINE_LENGTH(
      "Line length must be 3690 bytes in accordance with MDS version referenced in PDPM Grouper Jar Package document: length=%s"),
  PROCESS_ERROR("Unknown process error: %s");

  private String reason;

  private SnfError(String reason) {
    this.reason = reason;
  }

  public String getReason(String... args) {
    return String.format(this.ordinal() + ")" + reason, SnfUtils.cast(args));
  }

}
