/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfContext {
    private static final Logger log = LoggerFactory.getLogger(SnfContext.class);
    public static final String KEY_FMT = "%s.%s";
    public static final String MSG_FMT = "%s: %s";

    private SnfContext() {
    }

    public static <T, RT> RT trace(T input, RT result) {
        return SnfContext.traceImpl(null, input, result);
    }

    private static <T, RT> RT traceImpl(String key, T input, RT result) {
        if (log.isDebugEnabled()) {
            Throwable th = new Throwable();
            StackTraceElement st = th.getStackTrace()[2];
            String clazz = st.getClassName();
            String method = st.getMethodName();
            key = String.format(KEY_FMT, clazz, method);
            log.debug(String.format(MSG_FMT, key, input));
        }
        return result;
    }

    public static <T> T trace(String key, T result) {
        return SnfContext.traceImpl(key, result, result);
    }

    public static <T> T trace(T result) {
        return SnfContext.traceImpl(null, result, result);
    }
}

