/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model;

import gov.cms.grouper.snf.lego.SnfUtils;

public class Assessment {
    public static final int NULL_VALUE = Integer.MIN_VALUE;
    public static final int CHECKED = 1;
    private final String name;
    private final String item;
    private final int value;
    private final boolean isBlank;
    private final boolean isAssessed;

    public Assessment(String name, String item, Integer value) {
        this.name = name;
        this.item = item;
        this.value = value;
        this.isBlank = false;
        this.isAssessed = true;
    }

    public Assessment(String name, String item, String value) {
        int tempVal;
        this.name = name;
        this.item = item;
        try {
            tempVal = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            tempVal = Integer.MIN_VALUE;
        }
        this.value = tempVal;
        this.isBlank = value.isEmpty() || value.contains("^");
        this.isAssessed = !value.contains("-");
    }

    public String getName() {
        return this.name;
    }

    public String getItem() {
        return this.item;
    }

    public int getValueInt() {
        return SnfUtils.nullCheck(this.value, Integer.MIN_VALUE, this.value);
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public boolean isAssessed() {
        return this.isAssessed;
    }

    public boolean isCheck() {
        return this.getValueInt() == 1;
    }

    public String toString() {
        return "Assessment{name='" + this.name + '\'' + ", item='" + this.item + '\'' + ", value=" + this.value + '}';
    }
}

