/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.PdxEligibility;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.table.BasicRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class DiagnosisMasterRow
extends BasicRow {
    private String code;
    private String clinicalCategory;
    private String slpCategory;
    private String ntaCategory;
    private PdxEligibility pdxEligibility;

    private DiagnosisMasterRow() {
    }

    public DiagnosisMasterRow(String code, String clinicalCategory, String slpCategory, String ntaCategory, PdxEligibility pdxEligibility) {
        this.code = code;
        this.clinicalCategory = clinicalCategory;
        this.slpCategory = slpCategory;
        this.ntaCategory = ntaCategory;
        this.pdxEligibility = pdxEligibility;
    }

    public String getCode() {
        return this.code;
    }

    public String getClinicalCategory() {
        return this.clinicalCategory;
    }

    public String getSlpCategory() {
        return this.slpCategory;
    }

    public String getNtaCategory() {
        return this.ntaCategory;
    }

    public PdxEligibility getPdxEligibility() {
        return this.pdxEligibility;
    }

    public SnfDiagnosisCode of() {
        SnfDiagnosisCode snfDiagnosisCode = new SnfDiagnosisCode(this.code, this.clinicalCategory, this.slpCategory, this.ntaCategory);
        return snfDiagnosisCode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.clinicalCategory == null ? 0 : this.clinicalCategory.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.ntaCategory == null ? 0 : this.ntaCategory.hashCode());
        result = 31 * result + (this.slpCategory == null ? 0 : this.slpCategory.hashCode());
        result = 31 * result + (this.pdxEligibility == null ? 0 : this.pdxEligibility.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagnosisMasterRow other = (DiagnosisMasterRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.clinicalCategory == null ? other.clinicalCategory != null : !this.clinicalCategory.equals(other.clinicalCategory)) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.ntaCategory == null ? other.ntaCategory != null : !this.ntaCategory.equals(other.ntaCategory)) {
            return false;
        }
        if (this.slpCategory == null ? other.slpCategory != null : !this.slpCategory.equals(other.slpCategory)) {
            return false;
        }
        return !(this.pdxEligibility == null ? other.pdxEligibility != null : this.pdxEligibility != other.pdxEligibility);
    }

    public static class Builder
    extends CsvBuilder<DiagnosisMasterRow> {
        private static final BiConsumer<DiagnosisMasterRow, String> code = (modelRow, value) -> DiagnosisMasterRow.access$502(modelRow, SnfUtils.clean(value));
        private static final BiConsumer<DiagnosisMasterRow, String> clinicalCategory = (modelRow, value) -> DiagnosisMasterRow.access$402(modelRow, SnfUtils.clean(value));
        private static final BiConsumer<DiagnosisMasterRow, String> slpCategory = (modelRow, value) -> DiagnosisMasterRow.access$302(modelRow, SnfUtils.clean(value));
        private static final BiConsumer<DiagnosisMasterRow, String> ntaCategory = (modelRow, value) -> DiagnosisMasterRow.access$202(modelRow, SnfUtils.clean(value));
        private static final BiConsumer<DiagnosisMasterRow, String> pdxEligibility = (modelRow, value) -> DiagnosisMasterRow.access$102(modelRow, PdxEligibility.of(value));
        private static final Builder singleton = new Builder();

        public static Map<Integer, BiConsumer<DiagnosisMasterRow, String>> initCsvMapping() {
            HashMap<Integer, BiConsumer<DiagnosisMasterRow, String>> result = new HashMap<Integer, BiConsumer<DiagnosisMasterRow, String>>();
            result.put(0, code);
            result.put(1, BasicRow.getLowVersionParser());
            result.put(2, BasicRow.getHighVersionParser());
            result.put(3, clinicalCategory);
            result.put(4, slpCategory);
            result.put(5, ntaCategory);
            result.put(6, pdxEligibility);
            return Collections.unmodifiableMap(result);
        }

        private Builder() {
            super(() -> new DiagnosisMasterRow(), Builder.initCsvMapping());
        }

        public static Builder of() {
            return singleton;
        }
    }
}

