package gov.cms.grouper.snf.lego;

public class Pair<ONET, TWOT> {

  private final ONET one;
  private final TWOT two;

  public Pair(ONET one, TWOT two) {
    super();
    this.one = one;
    this.two = two;
  }

  public ONET getOne() {
    return this.one;
  }

  public TWOT getTwo() {
    return this.two;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.one == null) ? 0 : this.one.hashCode());
    result = prime * result + ((this.two == null) ? 0 : this.two.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    @SuppressWarnings("unchecked")
    Pair<ONET, TWOT> other = (Pair<ONET, TWOT>) obj;
    if (this.one == null) {
      if (other.one != null) {
        return false;
      }
    } else if (!this.one.equals(other.one)) {
      return false;
    }
    if (this.two == null) {
      if (other.two != null) {
        return false;
      }
    } else if (!this.two.equals(other.two)) {
      return false;
    }
    return true;
  }

  public static <ONET, TWOT> Pair<ONET, TWOT> of(ONET one, TWOT two) {
    return new Pair<>(one, two);
  }

}
