package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SlpCmgRow extends BasicRow {
  private String cmg;
  private Integer presenceOfAncSlCi;
  private Integer mechAltDietOrSwallowDisorder;

  private SlpCmgRow() {
    this(null, null, null);
  }

  public SlpCmgRow(String cmg, Integer presenceOfAncSlCi, Integer mechAltDietOrSwallowDisorder) {
    super();
    this.cmg = cmg;
    this.presenceOfAncSlCi = presenceOfAncSlCi;
    this.mechAltDietOrSwallowDisorder = mechAltDietOrSwallowDisorder;
  }

  public String getCmg() {
    return this.cmg;
  }

  public Integer getPresenceOfAncSlCi() {
    return this.presenceOfAncSlCi;
  }

  public Integer getMechAltDietOrSwallowDisorder() {
    return this.mechAltDietOrSwallowDisorder;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((this.cmg == null) ? 0 : this.cmg.hashCode());
    result = prime * result + ((this.mechAltDietOrSwallowDisorder == null) ? 0
        : this.mechAltDietOrSwallowDisorder.hashCode());
    result =
        prime * result + ((this.presenceOfAncSlCi == null) ? 0 : this.presenceOfAncSlCi.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    SlpCmgRow other = (SlpCmgRow) obj;
    if (super.equals(other) == false) {
      return false;
    }
    if (this.cmg == null) {
      if (other.cmg != null) {
        return false;
      }
    } else if (!this.cmg.equals(other.cmg)) {
      return false;
    }
    if (this.mechAltDietOrSwallowDisorder == null) {
      if (other.mechAltDietOrSwallowDisorder != null) {
        return false;
      }
    } else if (!this.mechAltDietOrSwallowDisorder.equals(other.mechAltDietOrSwallowDisorder)) {
      return false;
    }
    if (this.presenceOfAncSlCi == null) {
      if (other.presenceOfAncSlCi != null) {
        return false;
      }
    } else if (!this.presenceOfAncSlCi.equals(other.presenceOfAncSlCi)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<SlpCmgRow> {

    private static final BiConsumer<SlpCmgRow, String> presenceOfAncSlCi =
        (row, str) -> row.presenceOfAncSlCi = SnfUtils.parse(str, null);

    private static final BiConsumer<SlpCmgRow, String> mechAltDietOrSwallowDisorder =
        (row, str) -> row.mechAltDietOrSwallowDisorder = SnfUtils.parse(str, null);

    private static final BiConsumer<SlpCmgRow, String> cmg =
        (row, str) -> row.cmg = SnfUtils.clean(str);

    private static final SlpCmgRow.Builder singleton = new SlpCmgRow.Builder();

    public static Map<Integer, BiConsumer<SlpCmgRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<SlpCmgRow, String>> result = new HashMap<>();
      result.put(0, SlpCmgRow.Builder.presenceOfAncSlCi);
      result.put(1, SnfUtils.cast(BasicRow.getLowVersionParser()));
      result.put(2, SnfUtils.cast(BasicRow.getHighVersionParser()));
      result.put(3, SlpCmgRow.Builder.mechAltDietOrSwallowDisorder);
      result.put(4, SlpCmgRow.Builder.cmg);

      return Collections.unmodifiableMap(result);
    }

    private Builder() {
      super(SlpCmgRow::new, SlpCmgRow.Builder.initCsvMapping());
    }

    public static SlpCmgRow.Builder of() {
      return SlpCmgRow.Builder.singleton;
    }
  }
}
