package gov.cms.grouper.snf.model.reader;

import gov.cms.grouper.snf.model.AssessmentType;
import java.util.List;

public interface AssessmentItem {

  /**
   * Gets the character position in a flat file format record. This is 1 based value.
   * 
   * @return if valid, a value greater than 0
   */
  int getIndex();

  /**
   * Gets the length of the field.
   * 
   * @return if valid, a value greater than 0
   */
  int getLength();

  /**
   * Gets the assessment item official name.
   * 
   * @return non-null name
   */
  String name();

  /**
   * Gets the XML tag used for the assessment name in an XML file. Optional.
   * 
   * @return may be null. If null, use the name() method.
   */
  String getXmlTag();

  /**
   * Gets the assessment type, which is a way to group them in the RAI form or in logic.
   * 
   * @return non-null Assessment type
   */
  AssessmentType getAssessmentType();

  /**
   * A valid value indicator that allows blank values in the assessment.
   * 
   * @return true if blanks are allowed.
   */
  boolean isBlankAllowed();

  /**
   * A valid value indicator that allows values to be skipped or not assessed in the assessment.
   * 
   * @return true if skipping, or not assessed is allowed.
   */
  boolean isNotAssessedAllowed();

  /**
   * Gets the list of valid values.
   * 
   * @return may be null if there are no valid values.
   */
  List<Integer> getValidValues();

  /**
   * Gets the list of Enums. This is similar to enum.values().
   * 
   * @return non-null array of enums.
   */
  AssessmentItem[] getEnumValues();

}
