/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PpsAssessment {
    FIVE_DAY(1, "5-day scheduled assessment"),
    INTERIM_PAYMENT_ASSESSMENT(8, "Interim Payment Assessment"),
    NONE(99, "None of the above");

    private Integer value;
    private String description;
    private static final Map<Integer, PpsAssessment> valueMap;

    private PpsAssessment(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Optional<PpsAssessment> of(Integer value) {
        return Optional.ofNullable(valueMap.get(value));
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        valueMap = new HashMap<Integer, PpsAssessment>();
        for (PpsAssessment ppsAssessment : PpsAssessment.values()) {
            valueMap.put(ppsAssessment.value, ppsAssessment);
        }
    }
}

