/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data;
import gov.cms.grouper.snf.model.enums.CognitiveLevel;
import gov.cms.grouper.snf.model.table.BasicRow;

public class CognitiveLevelRow
extends BasicRow {
    private CognitiveLevel cognitiveLevel;
    private Integer lowScore;
    private Integer highScore;

    public boolean isScore(Integer check) {
        boolean passesLow = this.lowScore == null || this.lowScore <= check;
        boolean passesHigh = this.highScore != null && this.highScore >= check;
        return passesLow && passesHigh;
    }

    private CognitiveLevelRow() {
    }

    public CognitiveLevelRow(Integer lowVersion, Integer highVersion, CognitiveLevel cognitiveLevel, Integer lowScore, Integer highScore) {
        super(lowVersion, highVersion);
        this.cognitiveLevel = cognitiveLevel;
        this.lowScore = lowScore;
        this.highScore = highScore;
    }

    public CognitiveLevel getCognitiveLevel() {
        return this.cognitiveLevel;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = this.getHashCode(result, 31);
        result = 31 * result + (this.cognitiveLevel == null ? 0 : this.cognitiveLevel.hashCode());
        result = 31 * result + (this.highScore == null ? 0 : this.highScore.hashCode());
        result = 31 * result + (this.lowScore == null ? 0 : this.lowScore.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CognitiveLevelRow other = (CognitiveLevelRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.cognitiveLevel != other.cognitiveLevel) {
            return false;
        }
        if (this.highScore == null ? other.highScore != null : !this.highScore.equals(other.highScore)) {
            return false;
        }
        return !(this.lowScore == null ? other.lowScore != null : !this.lowScore.equals(other.lowScore));
    }

    public static CognitiveLevelRow build(Data.CalcOfPdpmLvlFromBims level) {
        return new CognitiveLevelRow(level.getLowVersion(), level.getHighVersion(), CognitiveLevel.of(level.getPdpmCogLvl()), level.getBimsScoreLow(), level.getBimsScoreHigh());
    }
}

