/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class SnfVersionRow {
    private Integer internalVersion;
    private LocalDate from;
    private LocalDate to;
    private String version;
    private String itemSetVersion;

    public boolean isDate(LocalDate check) {
        boolean passesLow = this.from == null || this.from.equals(check) || this.from.isBefore(check);
        boolean passesHigh = this.to == null || this.to.equals(check) || this.to.isAfter(check);
        return passesLow && passesHigh;
    }

    private SnfVersionRow() {
    }

    public SnfVersionRow(Integer internalVersion, LocalDate from, LocalDate to, String version, String itemSetVersion) {
        this.internalVersion = internalVersion;
        this.from = from;
        this.to = to;
        this.version = version;
        this.itemSetVersion = itemSetVersion;
    }

    public Integer getInternalVersion() {
        return this.internalVersion;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public String getVersion() {
        return this.version;
    }

    public String getItemSetVersion() {
        return this.itemSetVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.internalVersion == null ? 0 : this.internalVersion.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnfVersionRow other = (SnfVersionRow)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        if (this.internalVersion == null ? other.internalVersion != null : !this.internalVersion.equals(other.internalVersion)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static SnfVersionRow build(Data.Version version) {
        return new SnfVersionRow(Integer.parseInt(version.getInternalVersion()), LocalDate.parse(version.getStartDate(), DateTimeFormatter.BASIC_ISO_DATE), LocalDate.parse(version.getEndDate(), DateTimeFormatter.BASIC_ISO_DATE), version.getVersion(), version.getItmSetVersionCd());
    }
}

