/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.model.SnfProcessException;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.r2.logic.nursing.BscpLogic;
import gov.cms.grouper.snf.r2.logic.nursing.ReducedPhysicalFunctionLogic;
import gov.cms.grouper.snf.r2.logic.nursing.SpecialCare;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NursingLogic
extends SnfDataVersionImpl<NursingCmg> {
    private static final Logger log = LoggerFactory.getLogger(NursingLogic.class);
    public static final List<Rai300> EXTENSIVE_SERVICES = Arrays.asList(Rai300.O0100E2, Rai300.O0100F2, Rai300.O0100M2);
    private final ClaimInfo claim;
    private final SpecialCare specialCare;
    private final ReducedPhysicalFunctionLogic physical;
    private final BscpLogic bscp;

    public NursingLogic(ClaimInfo claim, SpecialCare specialCare, ReducedPhysicalFunctionLogic physical, BscpLogic bscp) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.specialCare = specialCare;
        this.physical = physical;
        this.bscp = bscp;
    }

    protected List<Rai300> getCodeServices() {
        List<Rai300> services = EXTENSIVE_SERVICES.stream().filter(item -> {
            boolean result = this.claim.isCheckedAndNotNull((Rai300)((Object)item));
            return result;
        }).collect(Collectors.toList());
        return services;
    }

    protected NursingCmg evaluateExtensiveServices() {
        List<Rai300> codedServices = this.getCodeServices();
        int nursingFunctionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (codedServices != null && !codedServices.isEmpty()) {
            result = nursingFunctionScore >= 15 ? this.specialCare.evaluateClinicallyComplex() : (codedServices.contains((Object)Rai300.O0100E2) && codedServices.contains((Object)Rai300.O0100F2) ? NursingCmg.ES3 : (codedServices.contains((Object)Rai300.O0100E2) || codedServices.contains((Object)Rai300.O0100F2) ? NursingCmg.ES2 : (codedServices.contains((Object)Rai300.O0100M2) && !codedServices.contains((Object)Rai300.O0100E2) && !codedServices.contains((Object)Rai300.O0100F2) ? NursingCmg.ES1 : null)));
        }
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        NursingCmg cmg = this.evaluateExtensiveServices();
        if (cmg == null) {
            SnfDataVersionImpl com;
            List<SnfDataVersionImpl> components = Arrays.asList(this.specialCare, this.bscp, this.physical);
            Iterator<SnfDataVersionImpl> iterator = components.iterator();
            while (iterator.hasNext() && (cmg = (NursingCmg)((Object)(com = iterator.next()).exec())) == null) {
            }
        }
        if (cmg == null) {
            throw new SnfProcessException("Unable to determine CMG for Nursing Logic");
        }
        return SnfContext.trace(cmg);
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }

    public SpecialCare getSpecialCare() {
        return this.specialCare;
    }

    public ReducedPhysicalFunctionLogic getPhysical() {
        return this.physical;
    }

    public BscpLogic getBscp() {
        return this.bscp;
    }
}

