/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.transfer;

import com.mmm.his.cer.foundation.model.ICode;
import com.mmm.his.cer.foundation.transfer.Claim;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.enums.AssessmentIndicator;
import gov.cms.grouper.snf.model.enums.AssessmentType;
import gov.cms.grouper.snf.model.enums.ObraAssessment;
import gov.cms.grouper.snf.model.enums.PpsAssessment;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.enums.SnfError;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SnfClaim
extends Claim
implements ISnfClaim {
    private static final long serialVersionUID = -6053717059913154415L;
    private int version;
    private Map<String, Assessment> assessmentMap = new HashMap<String, Assessment>();
    private LocalDate assessmentReferenceDate;
    private Integer obra;
    private Integer pps;
    private String hippsCode = "";
    private String recalculated_z0100b = "";
    private String mdsRaiVersion = "";
    private final List<String> errors = new ArrayList<String>();
    private String originalRecord;

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public String getRecalculated_z0100b() {
        return this.recalculated_z0100b;
    }

    public void setRecalculated_z0100b(String recalculated_z0100b) {
        this.recalculated_z0100b = recalculated_z0100b;
    }

    @Override
    public SnfDiagnosisCode getPrimaryDiagnosis() {
        return this.getCodes(SnfDiagnosisCode.class).stream().findFirst().orElse(null);
    }

    @Override
    public void setPrimaryDiagnosis(SnfDiagnosisCode pdx) {
        if (this.codes.isEmpty()) {
            this.codes.add(pdx);
        } else {
            this.codes.set(0, pdx);
        }
    }

    public void insertPrimaryDiagnosis(SnfDiagnosisCode pdx) {
        this.codes.add(0, pdx);
    }

    @Override
    public List<SnfDiagnosisCode> getSecondaryDiagnoses() {
        return this.getCodes(SnfDiagnosisCode.class).stream().skip(1L).collect(Collectors.toList());
    }

    @Override
    public void addAssessment(Assessment assessment) {
        this.assessmentMap.put(assessment.getItem(), assessment);
    }

    @Override
    public Map<String, Assessment> getAssessmentMap() {
        return this.assessmentMap;
    }

    public void setAssessmentMap(Map<String, Assessment> assessments) {
        this.assessmentMap = assessments;
    }

    public LocalDate getAssessmentReferenceDate() {
        return this.assessmentReferenceDate;
    }

    public void setAssessmentReferenceDate(LocalDate assessmentReferenceDate) {
        this.assessmentReferenceDate = assessmentReferenceDate;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrors(String error) {
        this.errors.add(error);
    }

    @Override
    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    @Override
    public String getHippsCode() {
        return this.hippsCode;
    }

    @Override
    public void setHippsCode(String code) {
        this.hippsCode = code;
    }

    @Override
    public String getOriginalRecord() {
        return this.originalRecord;
    }

    @Override
    public void setOriginalRecord(String originalRecord) {
        this.originalRecord = originalRecord;
    }

    @Override
    @Deprecated
    public Integer getAiCode() {
        return this.getAssessmentIndicator();
    }

    @Override
    public Integer getAssessmentIndicator() {
        Optional<PpsAssessment> maybePpsAssessment = PpsAssessment.of(this.pps);
        if (maybePpsAssessment.isPresent()) {
            PpsAssessment ppsAssessment = maybePpsAssessment.get();
            switch (ppsAssessment) {
                case INTERIM_PAYMENT_ASSESSMENT: {
                    return AssessmentIndicator.INTERIM_PAYMENT_ASSESSMENT.getValue();
                }
                case FIVE_DAY: {
                    return AssessmentIndicator.FIVE_DAY.getValue();
                }
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void setAiCode(Integer code) {
    }

    @Override
    public void setPps(Integer pps) {
        this.pps = pps;
    }

    @Override
    public Integer getPps() {
        return this.pps;
    }

    @Override
    public Integer getObra() {
        return this.obra;
    }

    @Override
    public void setObra(Integer obra) {
        this.obra = obra;
    }

    public String getMdsRaiVersion() {
        return this.mdsRaiVersion;
    }

    public void setMdsRaiVersion(String mdsRaiVersion) {
        this.mdsRaiVersion = mdsRaiVersion;
    }

    public String toString() {
        return "SnfClaim{version=" + this.version + ", assessmentReferenceDate=" + this.assessmentReferenceDate + ", aiCode=" + AssessmentIndicator.of(this.getAssessmentIndicator()).orElse(null) + ", obra=" + ObraAssessment.of(this.obra).orElse(null) + ", pps=" + PpsAssessment.of(this.pps).orElse(null) + ", codes=" + this.codes + ", hippsCode='" + this.hippsCode + "', errors=" + this.errors + ", assessments=" + this.assessmentMap + ", originalRecord='" + this.originalRecord + '}';
    }

    public static SnfClaim mapMdsToClaim(String utfRecord) {
        SnfClaim claim = new SnfClaim();
        claim.setOriginalRecord(utfRecord);
        if (utfRecord.length() < 3688) {
            claim.addErrors(SnfError.INVALID_LINE_LENGTH.getReason(String.valueOf(utfRecord.length())));
        }
        for (Rai300 item : Rai300.values()) {
            int index = item.getIndex() - 1;
            String itemValue = utfRecord.substring(index, index + item.getLength());
            if (item.getAssessmentType() == AssessmentType.ARD) {
                try {
                    LocalDate ard = LocalDate.parse(itemValue, DateTimeFormatter.BASIC_ISO_DATE);
                    claim.setAssessmentReferenceDate(ard);
                }
                catch (DateTimeParseException e) {
                    claim.setAssessmentReferenceDate(null);
                }
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.PDX) {
                claim.insertPrimaryDiagnosis(new SnfDiagnosisCode(itemValue, null, null, null));
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.SERVICES) {
                if (itemValue.replaceAll("[.^]", "").trim().isEmpty()) continue;
                claim.addCode((ICode)new SnfDiagnosisCode(itemValue, null, null, null));
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.PPS) {
                int result;
                try {
                    result = Integer.parseInt(itemValue);
                }
                catch (Exception exception) {
                    result = Integer.MIN_VALUE;
                }
                claim.setPps(result);
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.OBRA) {
                int result;
                try {
                    result = Integer.parseInt(itemValue);
                }
                catch (Exception exception) {
                    result = Integer.MIN_VALUE;
                }
                int value = result;
                if (!Rai300.A0310A.getValidValues().contains(value)) continue;
                claim.setObra(value);
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.ERROR_REASON) continue;
            Assessment assessment = new Assessment(item.name(), item.getXmlTag(), itemValue);
            claim.addAssessment(assessment);
        }
        return claim;
    }

    public String mapClaimToMds() {
        String hippsCode = this.hasError() ? "       " : this.getHippsCode();
        StringBuilder record = new StringBuilder(this.getOriginalRecord());
        int hippsIndex = Rai300.RECALCULATED_Z0100A.getIndex() - 1;
        record.replace(hippsIndex, hippsIndex + hippsCode.length(), hippsCode);
        int versionIndex = Rai300.RECALCULATED_Z0100B.getIndex() - 1;
        String version = this.getRecalculated_z0100b();
        record.replace(versionIndex, versionIndex + version.length(), version);
        return record.toString();
    }
}

