package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.SlpCmg;

public class SlpCmgRow extends BasicRow {

  private String cmg;
  private Integer presenceOfAncSlCi;
  private Integer mechAltDietOrSwallowDisorder;

  private SlpCmgRow() {}

  public SlpCmgRow(Integer lowVersion, Integer highVersion, String cmg, Integer presenceOfAncSlCi, Integer mechAltDietOrSwallowDisorder) {
    super(lowVersion, highVersion);
    this.cmg = cmg;
    this.presenceOfAncSlCi = presenceOfAncSlCi;
    this.mechAltDietOrSwallowDisorder = mechAltDietOrSwallowDisorder;
  }

  public static SlpCmgRow build(SlpCmg cmg) {
    return new SlpCmgRow(cmg.getLowVersion(), cmg.getHighVersion(), cmg.getCmg(),
        cmg.getPresenceOfAncSlCi(), cmg.getMechAltDietOrSwallowDisorder());
  }

  public String getCmg() {
    return cmg;
  }

  public Integer getPresenceOfAncSlCi() {
    return presenceOfAncSlCi;
  }

  public Integer getMechAltDietOrSwallowDisorder() {
    return mechAltDietOrSwallowDisorder;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((cmg == null) ? 0 : cmg.hashCode());
    result = prime * result + ((mechAltDietOrSwallowDisorder == null) ? 0
                                                                      : mechAltDietOrSwallowDisorder.hashCode());
    result =
        prime * result + ((presenceOfAncSlCi == null) ? 0 : presenceOfAncSlCi.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    SlpCmgRow other = (SlpCmgRow) obj;
    if (super.equals(other) == false) {
      return false;
    }
    if (cmg == null) {
      if (other.cmg != null) {
        return false;
      }
    } else if (!cmg.equals(other.cmg)) {
      return false;
    }
    if (mechAltDietOrSwallowDisorder == null) {
      if (other.mechAltDietOrSwallowDisorder != null) {
        return false;
      }
    } else if (!mechAltDietOrSwallowDisorder.equals(other.mechAltDietOrSwallowDisorder)) {
      return false;
    }
    if (presenceOfAncSlCi == null) {
      if (other.presenceOfAncSlCi != null) {
        return false;
      }
    } else if (!presenceOfAncSlCi.equals(other.presenceOfAncSlCi)) {
      return false;
    }
    return true;
  }

}
