package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;

public enum PdxEligibility {
  ORTHOPEDIC_SURGERY("May be Eligible for One of the Two Orthopedic Surgery Categories"),
  NON_ORTHOPEDIC_SURGERY("May be Eligible for the Non-Orthopedic Surgery Category"),
  NOT_ELIGIBLE("N/A");

  private static final Map<String, PdxEligibility> CACHE = new HashMap<>();
  private final String description;

  PdxEligibility(String description) {
    this.description = description;
  }

  public static PdxEligibility of(String description) {
    if (PdxEligibility.CACHE.isEmpty()) {
      for (PdxEligibility eligibility : PdxEligibility.values()) {
        PdxEligibility.CACHE.put(eligibility.getDescription(), eligibility);
      }
    }

    return CACHE.get(description);
  }

  public String getDescription() {
    return description;
  }

}
