package gov.cms.grouper.snf.model.enums;

public enum SnfError {
  INVALID_ASSESSMENT_REFERENCE_DATE("Assessment reference date is missing or is invalid: %s"),
  /** Invalid "Type of assessment: OBRA" or "Type of assesment: PP" */
  INVALID_A0310A_OR_A0310B("Invalid A0310A: %s or A0310B: %s"),
  INVALID_LINE_LENGTH(
      "Line length is less than 3688 bytes (%s); PDPM Grouper unable to process further."),
  PROCESS_ERROR("Unknown process error: %s");

  private final String reason;

  private SnfError(String reason) {
    this.reason = reason;
  }

  public String getReason(String... params) {
    return String.format(ordinal() + ")" + reason, cast(params));
  }

  @SuppressWarnings("unchecked")
  private static <I, O> O cast(I input) {
    return (O) input;
  }

}
