package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.ClinicalCategoryMaster;
import gov.cms.grouper.snf.model.enums.PdxEligibility;

public class ClinicalCategoryMasterRow extends BasicRow {

  private String code;
  private String clinicalCategory;
  private PdxEligibility pdxEligibility;

  private ClinicalCategoryMasterRow() {}

  public ClinicalCategoryMasterRow(String code, Integer lowVersion, Integer highVersion, String clinicalCategory,
      PdxEligibility pdxEligibility) {
    super(lowVersion, highVersion);
    this.code = code;
    this.clinicalCategory = clinicalCategory;
    this.pdxEligibility = pdxEligibility;
  }

  public static ClinicalCategoryMasterRow build(ClinicalCategoryMaster row) {
    return new ClinicalCategoryMasterRow(row.getCode(), row.getLowVersion(), row.getHighVersion(),
        row.getClinicalCategory(), PdxEligibility.of(row.getPdxEligibility()));
  }

  public String getCode() {
    return this.code;
  }

  public String getClinicalCategory() {
    return this.clinicalCategory;
  }

  public PdxEligibility getPdxEligibility() {
    return this.pdxEligibility;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result =
        prime * result + ((this.clinicalCategory == null) ? 0 : this.clinicalCategory.hashCode());
    result = prime * result + ((this.code == null) ? 0 : this.code.hashCode());
    result = prime * result + ((this.pdxEligibility == null) ? 0 : this.pdxEligibility.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    ClinicalCategoryMasterRow other = (ClinicalCategoryMasterRow) obj;
    if (!super.equals(other)) {
      return false;
    }

    if (this.clinicalCategory == null) {
      if (other.clinicalCategory != null) {
        return false;
      }
    } else if (!this.clinicalCategory.equals(other.clinicalCategory)) {
      return false;
    }
    if (this.code == null) {
      if (other.code != null) {
        return false;
      }
    } else if (!this.code.equals(other.code)) {
      return false;
    }
    if (this.pdxEligibility == null) {
      if (other.pdxEligibility != null) {
        return false;
      }
    } else if (this.pdxEligibility != other.pdxEligibility) {
      return false;
    }
    return true;
  }
}
