package gov.cms.grouper.snf.transfer;

import com.mmm.his.cer.foundation.model.ICodeList;
import com.mmm.his.cer.foundation.transfer.IClaim;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.enums.AssessmentIndicator;

import java.util.List;
import java.util.Map;

/**
 * Defines the SNF claim.
 */
public interface ISnfClaim extends IClaim, ICodeList {
  // INPUTS

  int getVersion();

  void setVersion(int version);

  /**
   * Return the assessment indicator.
   * @deprecated
   * This method can be replaced with {@link ISnfClaim#getAssessmentIndicator()}.
   * @return the assessment indicator indicating which type of assessment was completed.
   */
  @Deprecated
  Integer getAiCode();

  Integer getAssessmentIndicator();

  /**
   * Set the assessment indicator indicating which type of assessment was completed.
   * @param code indicator value
   * @deprecated
   * This method is no longer has any functionality.
   */
  @Deprecated
  void setAiCode(Integer code);

  void setPps(Integer pps);
  Integer getPps();

  Integer getObra();

  void setObra(Integer obra);

  SnfDiagnosisCode getPrimaryDiagnosis();

  void setPrimaryDiagnosis(SnfDiagnosisCode pdx);

  List<SnfDiagnosisCode> getSecondaryDiagnoses();

  void addAssessment(Assessment assessment);

  Map<String, Assessment> getAssessmentMap();

  // OUTPUTS
  void addErrors(String error);

  List<String> getErrors();

  boolean hasError();

  String getHippsCode();

  void setHippsCode(String code);

  String getOriginalRecord();

  void setOriginalRecord(String originalRecord);

}
