/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data;
import gov.cms.grouper.snf.model.table.BasicRow;

public class NtaCmgRow
extends BasicRow {
    private String cmg;
    private Integer lowScore;
    private Integer highScore;

    public boolean isScore(Integer check) {
        boolean passesLow = this.lowScore == null || this.lowScore <= check;
        boolean passesHigh = this.highScore == null || this.highScore >= check;
        return passesLow && passesHigh;
    }

    private NtaCmgRow() {
    }

    public NtaCmgRow(Integer lowVersion, Integer highVersion, String cmg, Integer lowScore, Integer highScore) {
        super(lowVersion, highVersion);
        this.cmg = cmg;
        this.lowScore = lowScore;
        this.highScore = highScore < lowScore ? null : highScore;
    }

    public static NtaCmgRow build(Data.NtaCmg cmg) {
        return new NtaCmgRow(cmg.getLowVersion(), cmg.getHighVersion(), cmg.getCmg(), cmg.getNtaScoreRangeLow(), cmg.getNtaScoreRangeHigh());
    }

    public String getCmg() {
        return this.cmg;
    }

    public Integer getLowScore() {
        return this.lowScore;
    }

    public Integer getHighScore() {
        return this.highScore;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.cmg == null ? 0 : this.cmg.hashCode());
        result = 31 * result + (this.highScore == null ? 0 : this.highScore.hashCode());
        result = 31 * result + (this.lowScore == null ? 0 : this.lowScore.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NtaCmgRow other = (NtaCmgRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.cmg == null ? other.cmg != null : !this.cmg.equals(other.cmg)) {
            return false;
        }
        if (this.highScore == null ? other.highScore != null : !this.highScore.equals(other.highScore)) {
            return false;
        }
        return !(this.lowScore == null ? other.lowScore != null : !this.lowScore.equals(other.lowScore));
    }
}

