package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.SlpComorbidityMaster;

public class SlpComorbidityMasterRow extends BasicRow {

  private String code;
  private String slpCategory;

  private SlpComorbidityMasterRow() {}

  public SlpComorbidityMasterRow(String code, Integer lowVersion, Integer highVersion, String slpCategory) {
    super(lowVersion, highVersion);
    this.code = code;
    this.slpCategory = slpCategory;
  }

  public static SlpComorbidityMasterRow build(SlpComorbidityMaster row) {
    return new SlpComorbidityMasterRow(row.getCode(), row.getLowVersion(), row.getHighVersion(),
        row.getComorbidity());
  }

  public String getCode() {
    return this.code;
  }

  public String getSlpCategory() {
    return this.slpCategory;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((this.code == null) ? 0 : this.code.hashCode());
    result = prime * result + ((this.slpCategory == null) ? 0 : this.slpCategory.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    SlpComorbidityMasterRow other = (SlpComorbidityMasterRow) obj;
    if (!super.equals(other)) {
      return false;
    }
    if (this.code == null) {
      if (other.code != null) {
        return false;
      }
    } else if (!this.code.equals(other.code)) {
      return false;
    }
    if (this.slpCategory == null) {
      if (other.slpCategory != null) {
        return false;
      }
    } else if (!this.slpCategory.equals(other.slpCategory)) {
      return false;
    }
    return true;
  }
}
