package gov.cms.grouper.snf.r2.logic.nursing;

import gov.cms.grouper.snf.model.enums.AssessmentType;
import gov.cms.grouper.snf.model.enums.Rai300;
import java.util.EnumSet;
import java.util.Set;

public enum RaiSets {
  EATING_AND_TOILET_NON_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_EATING,
      AssessmentType.FUNCTIONAL_HYGIENE_TOILET
  ))),
  EATING_AND_TOILET_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_EATING_IPA,
      AssessmentType.FUNCTIONAL_HYGIENE_TOILET_IPA
  ))),
  BED_MOBILITY_NON_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_BED_MOBILITY_TO_LYING,
      AssessmentType.FUNCTIONAL_BED_MOBILITY_TO_SITTING
  ))),
  BED_MOBILITY_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_BED_MOBILITY_TO_LYING_IPA,
      AssessmentType.FUNCTIONAL_BED_MOBILITY_TO_SITTING_IPA
  ))),
  TRANSFER_NON_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_TRANSFER_CHAIR,
      AssessmentType.FUNCTIONAL_TRANSFER_TO_STANDING,
      AssessmentType.FUNCTIONAL_TRANSFER_TOILET
  ))),
  TRANSFER_IPA(Rai300.getAssessmentsByTypes(EnumSet.of(
      AssessmentType.FUNCTIONAL_TRANSFER_CHAIR_IPA,
      AssessmentType.FUNCTIONAL_TRANSFER_TO_STANDING_IPA,
      AssessmentType.FUNCTIONAL_TRANSFER_TOILET_IPA
  ))),
  BEHAVIORAL_SYMPTOMS(EnumSet.of(Rai300.E0200A, Rai300.E0200B, Rai300.E0200C, Rai300.E0800, Rai300.E0900)),
  BSCP_SERVICES(EnumSet.of(Rai300.O0500C, Rai300.O0500E, Rai300.O0500G, Rai300.O0500H, Rai300.O0500I, Rai300.O0500J))
  ;

  private final Set<Rai300> set;

  RaiSets(Set<Rai300> set) {
    this.set = set;
  }

  public Set<Rai300> getSet() {
    return set;
  }

}
