package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.CalcOfPdpmLvlFromBims;
import gov.cms.grouper.snf.model.SnfProcessException;
import gov.cms.grouper.snf.model.enums.CognitiveLevel;

public class CognitiveLevelRow extends BasicRow {

  public boolean isScore(Integer check) {
    boolean passesLow = lowScore == null || lowScore <= check;
    boolean passesHigh = highScore != null && highScore >= check;
    return passesLow && passesHigh;
  }

  private CognitiveLevel cognitiveLevel;
  private Integer lowScore;
  private Integer highScore;

  private CognitiveLevelRow() {}

  public CognitiveLevelRow(Integer lowVersion, Integer highVersion, CognitiveLevel cognitiveLevel, Integer lowScore, Integer highScore) {
    super(lowVersion,highVersion);
    this.cognitiveLevel = cognitiveLevel;
    this.lowScore = lowScore;
    this.highScore = highScore;
  }

  public CognitiveLevel getCognitiveLevel() {
    return cognitiveLevel;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = getHashCode(result, prime);
    result = prime * result + ((cognitiveLevel == null) ? 0 : cognitiveLevel.hashCode());
    result = prime * result + ((highScore == null) ? 0 : highScore.hashCode());
    result = prime * result + ((lowScore == null) ? 0 : lowScore.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    CognitiveLevelRow other = (CognitiveLevelRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (cognitiveLevel != other.cognitiveLevel) {
      return false;
    }
    if (highScore == null) {
      if (other.highScore != null) {
        return false;
      }
    } else if (!highScore.equals(other.highScore)) {
      return false;
    }
    if (lowScore == null) {
      if (other.lowScore != null) {
        return false;
      }
    } else if (!lowScore.equals(other.lowScore)) {
      return false;
    }
    return true;
  }

  public static CognitiveLevelRow build(CalcOfPdpmLvlFromBims level) {
    return new CognitiveLevelRow(
            level.getLowVersion(),
            level.getHighVersion(),
            CognitiveLevel.of(level.getPdpmCogLvl())
                    .orElseThrow(() -> new SnfProcessException(
                            "CognitiveLevel " + level.getPdpmCogLvl() + " not recognized, data issue!")),
            level.getBimsScoreLow(),
            level.getBimsScoreHigh());
  }

}
