package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.NtaCmg;

public class NtaCmgRow extends BasicRow {

  public boolean isScore(Integer check) {
    boolean passesLow = lowScore == null || lowScore <= check;
    boolean passesHigh = highScore == null || highScore >= check;
    return passesLow && passesHigh;
  }

  private String cmg;
  private Integer lowScore;
  private Integer highScore;

  private NtaCmgRow() {}

  public NtaCmgRow(Integer lowVersion, Integer highVersion, String cmg, Integer lowScore, Integer highScore) {
    super(lowVersion, highVersion);
    this.cmg = cmg;
    this.lowScore = lowScore;
    this.highScore = highScore < lowScore ? null : highScore;
  }

  public static NtaCmgRow build(NtaCmg cmg) {
    return new NtaCmgRow(cmg.getLowVersion(), cmg.getHighVersion(), cmg.getCmg(),
        cmg.getNtaScoreRangeLow(), cmg.getNtaScoreRangeHigh());
  }

  public String getCmg() {
    return cmg;
  }

  public Integer getLowScore() {
    return lowScore;
  }

  public Integer getHighScore() {
    return highScore;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((cmg == null) ? 0 : cmg.hashCode());
    result = prime * result + ((highScore == null) ? 0 : highScore.hashCode());
    result = prime * result + ((lowScore == null) ? 0 : lowScore.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    NtaCmgRow other = (NtaCmgRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (cmg == null) {
      if (other.cmg != null) {
        return false;
      }
    } else if (!cmg.equals(other.cmg)) {
      return false;
    }
    if (highScore == null) {
      if (other.highScore != null) {
        return false;
      }
    } else if (!highScore.equals(other.highScore)) {
      return false;
    }
    if (lowScore == null) {
      if (other.lowScore != null) {
        return false;
      }
    } else if (!lowScore.equals(other.lowScore)) {
      return false;
    }
    return true;
  }

}
