/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.app;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.grouper.snf.process.SnfProcessor;
import gov.cms.grouper.snf.process.SnfValidations;
import gov.cms.grouper.snf.transfer.SnfClaim;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdpm {
    private static final Logger LOG = LoggerFactory.getLogger(Pdpm.class);
    private final SnfProcessorProxy processor = new SnfProcessorProxy();
    protected boolean ignoreExceptionOnTryExec;

    public static String stringExec(String line) {
        Pdpm pdpm = new Pdpm();
        return pdpm.handleLine(line, null).mapClaimToMds();
    }

    public SnfClaim exec(String claimString) {
        return this.handleLine(claimString, null);
    }

    public SnfClaim xmlStringExec(String claimString) {
        return this.handleXmlString(claimString, null);
    }

    public SnfClaim exec(SnfClaim claim) {
        return this.handleClaim(claim, null);
    }

    public List<SnfClaim> exec(File snfFile) {
        ArrayList<SnfClaim> claims = new ArrayList<SnfClaim>(5000);
        this.exec(snfFile.toPath(), claims::add);
        return claims;
    }

    public void exec(Path path, Consumer<SnfClaim> additionalPostProcessing) {
        this.handleFile(path, additionalPostProcessing);
    }

    private SnfClaim handleLine(String claimString, Consumer<SnfClaim> finalProcessing) {
        SnfClaim claim = SnfClaim.mapMdsToClaim(claimString);
        return this.handleClaim(claim, finalProcessing);
    }

    private SnfClaim handleXmlString(String claimString, Consumer<SnfClaim> finalProcessing) {
        try {
            SnfClaim claim = SnfClaim.mapXmlStringToClaim(claimString);
            return this.handleClaim(claim, finalProcessing);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private SnfClaim handleClaim(SnfClaim claim, Consumer<SnfClaim> finalProcessing) {
        SnfValidations.validateInputs(claim);
        try {
            return this.processor.process(claim, finalProcessing);
        }
        catch (Throwable th) {
            if (this.ignoreExceptionOnTryExec) {
                finalProcessing.accept(claim);
                return claim;
            }
            throw new RuntimeException(th);
        }
    }

    private void handleFile(Path path, Consumer<SnfClaim> additionalPostProcessing) {
        if (path.toString().endsWith(".xml")) {
            try {
                LOG.debug("Processing file: " + path.getFileName());
                SnfClaim claim = SnfClaim.mapXmlFileToClaim(path.toString());
                this.handleClaim(claim, additionalPostProcessing);
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        } else {
            Pdpm.handleFixedWidthFile(path, line -> this.handleLine((String)line, additionalPostProcessing));
        }
    }

    private static <T> void handleFixedWidthFile(Path path, Function<String, T> lineExec) {
        try (Scanner sc = new Scanner(path, "UTF-8");){
            LOG.debug("Processing file: " + path.getFileName());
            Thread closeFileThread = new Thread(() -> {
                LOG.debug("closing files");
                sc.close();
            });
            Runtime.getRuntime().addShutdownHook(closeFileThread);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (sc.ioException() != null) {
                    throw sc.ioException();
                }
                lineExec.apply(line);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static class SnfProcessorProxy
    extends SnfProcessor {
        private SnfProcessorProxy() {
        }

        @Override
        protected SnfClaim process(SnfClaim claim, Consumer<SnfClaim> finalProcessing) throws FoundationException, IOException {
            return super.process(claim, finalProcessing);
        }
    }
}

