/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.enums.CognitiveLevel;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.table.CognitiveLevelRow;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Collection;
import java.util.function.Supplier;

public class CognitiveLevelLogic
extends SnfDataVersionImpl<CognitiveLevel> {
    private final ClaimInfo claim;

    public CognitiveLevelLogic(ClaimInfo claim) {
        super(claim.getDataVersion());
        this.claim = claim;
    }

    protected CognitiveLevel step1(Assessment bimsSummaryScore) {
        CognitiveLevelRow row;
        CognitiveLevel result = null;
        if (CognitiveLevelLogic.hasSummaryScore(bimsSummaryScore) && (row = (CognitiveLevelRow)SnfTables.cognitiveLeveltable.values().stream().flatMap(Collection::stream).filter(item -> item.isVersion(this.getDataVersion()) && item.isScore(bimsSummaryScore.getValueInt())).findFirst().orElse(null)) != null) {
            result = row.getCognitiveLevel();
        }
        return SnfContext.trace(result);
    }

    private static boolean hasSummaryScore(Assessment bimsSummaryScore) {
        boolean result = bimsSummaryScore != null;
        result = result && !bimsSummaryScore.isBlank();
        result = result && bimsSummaryScore.isAssessed();
        result = result && bimsSummaryScore.getValueInt() != 99;
        return SnfContext.trace(result);
    }

    protected CognitiveLevel step2() {
        int c1000 = this.claim.getAssessmentValue(Rai300.C1000);
        CognitiveLevel result = CognitiveLevelLogic.step2a(c1000, this.claim::isComaAndNoActivities);
        if (result == null) {
            int b0700 = this.claim.getAssessmentValue(Rai300.B0700);
            int c0700 = this.claim.getAssessmentValue(Rai300.C0700);
            result = CognitiveLevelLogic.step2bTo2e(b0700, c1000, c0700);
        }
        return SnfContext.trace(result);
    }

    protected static CognitiveLevel step2a(int c1000, Supplier<Boolean> isComa) {
        return SnfContext.trace(c1000 == 3 || isComa.get() != false ? CognitiveLevel.SEVERELY_IMPAIRED : null);
    }

    protected static CognitiveLevel step2bTo2e(int b0700, int c1000, int c0700) {
        int basicImpairmentCount = CognitiveLevelLogic.getBasicImpairmentCount(b0700, c1000, c0700);
        int severeImpairmentCount = CognitiveLevelLogic.getSevereImpairmentCount(b0700, c1000);
        CognitiveLevel result = severeImpairmentCount >= 1 && basicImpairmentCount >= 2 ? CognitiveLevel.MODERATELY_IMPAIRED : (basicImpairmentCount >= 1 ? CognitiveLevel.MILDLY_IMPAIRED : CognitiveLevel.COGNITIVELY_INTACT);
        return SnfContext.trace(result);
    }

    private static int getSevereImpairmentCount(int b0700, int c1000) {
        int severeImpairmentCount = 0;
        severeImpairmentCount += c1000 == 2 ? 1 : 0;
        return severeImpairmentCount += b0700 == 2 || b0700 == 3 ? 1 : 0;
    }

    private static int getBasicImpairmentCount(int b0700, int c1000, int c0700) {
        int basicImpairmentCount = 0;
        basicImpairmentCount += c1000 == 1 || c1000 == 2 ? 1 : 0;
        basicImpairmentCount += b0700 >= 1 && b0700 <= 3 ? 1 : 0;
        return basicImpairmentCount += c0700 == 1 ? 1 : 0;
    }

    @Override
    public CognitiveLevel exec() {
        CognitiveLevel result = this.step1(this.claim.getAssessment(Rai300.C0500));
        if (result == null) {
            result = this.step2();
        }
        return SnfContext.trace(result);
    }
}

