/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class SpecialCare
extends SnfDataVersionImpl<NursingCmg> {
    public static final List<Rai300> SKIN_TREATMENTS = Arrays.asList(Rai300.M1200C, Rai300.M1200D, Rai300.M1200E, Rai300.M1200G, Rai300.M1200H);
    public static final List<Rai300> SKIN_TREATMENTS_2 = Arrays.asList(Rai300.M1200A, Rai300.M1200B);
    private final ClaimInfo claim;

    public SpecialCare(ClaimInfo claim) {
        super(claim.getDataVersion());
        this.claim = claim;
    }

    protected NursingCmg evaluateSpecialCareHigh() {
        int functionScore = this.claim.getFunctionScore();
        NursingCmg cmg = null;
        if (0 <= functionScore && functionScore <= 5) {
            cmg = this.isDepressed() ? NursingCmg.HDE2 : NursingCmg.HDE1;
        } else if (6 <= functionScore && functionScore <= 14) {
            cmg = this.isDepressed() ? NursingCmg.HBC2 : NursingCmg.HBC1;
        } else if (functionScore >= 15) {
            cmg = this.evaluateClinicallyComplex();
        }
        return SnfContext.trace("Special Care High CMG", cmg);
    }

    protected boolean isSpecialCareHighApplicable() {
        Predicate<Object> eval = o -> false;
        eval = eval.or(o -> this.isComatose()).or(o -> this.isSepticemia()).or(o -> this.isDiabetes()).or(o -> this.isQuadriplegia()).or(o -> this.isTroubleBreathing()).or(o -> this.isParenteral()).or(o -> this.isSick()).or(o -> this.isRespiratory());
        return SnfContext.trace(eval.test(null));
    }

    protected NursingCmg evaluateSpecialCareLow() {
        int functionScore = this.claim.getFunctionScore();
        NursingCmg cmg = null;
        if (0 <= functionScore && functionScore <= 5) {
            cmg = this.isDepressed() ? NursingCmg.LDE2 : NursingCmg.LDE1;
        } else if (6 <= functionScore && functionScore <= 14) {
            cmg = this.isDepressed() ? NursingCmg.LBC2 : NursingCmg.LBC1;
        } else if (15 <= functionScore) {
            cmg = this.evaluateClinicallyComplex();
        }
        return SnfContext.trace("Special Care Low CMG", cmg);
    }

    public boolean isSpecialCareLowApplicable() {
        Predicate<Object> eval = o -> false;
        eval = eval.or(o -> this.isCerebralPalsy()).or(o -> this.isMultiSclerosis()).or(o -> this.isParkinson()).or(o -> this.isRespiratoryOxyTherapy()).or(o -> this.isStage2Ulcer()).or(o -> this.isStage3Or4Ulcer()).or(o -> this.isTwoOrMoreVenousArterialUlcers()).or(o -> this.isStage2UlcerAndVenousArterialUlcer()).or(o -> this.isFoot()).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100B2)).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100J2)).or(o -> this.isClassifiedTubeFeeding());
        boolean result = eval.test(null);
        return result;
    }

    public NursingCmg evaluateClinicallyComplex() {
        int functionScore = this.claim.getFunctionScore();
        NursingCmg cmg = null;
        if (0 <= functionScore && functionScore <= 5) {
            cmg = this.isDepressed() ? NursingCmg.CDE2 : NursingCmg.CDE1;
        } else if (6 <= functionScore && functionScore <= 14) {
            cmg = this.isDepressed() ? NursingCmg.CBC2 : NursingCmg.CBC1;
        } else if (15 <= functionScore && functionScore <= 16) {
            cmg = this.isDepressed() ? NursingCmg.CA2 : NursingCmg.CA1;
        }
        return SnfContext.trace("Clinically Complex CMG", cmg);
    }

    public boolean isClinicallyComplexApplicable() {
        Predicate<Object> eval = o -> false;
        eval = eval.or(o -> this.claim.isCheckedAndNotNull(Rai300.I2000)).or(o -> this.isHemiplegiaOrHemiparesis()).or(o -> this.isOpenLesions()).or(o -> this.claim.isCheckedAndNotNull(Rai300.M1040F)).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100A2)).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100C2)).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100H2)).or(o -> this.claim.isCheckedAndNotNull(Rai300.O0100I2));
        boolean result = eval.test(null);
        return result;
    }

    private boolean isOpenLesions() {
        return !(!this.claim.isCheckedAndNotNull(Rai300.M1040D) && !this.claim.isCheckedAndNotNull(Rai300.M1040E) || !this.claim.isCheckedAndNotNull(Rai300.M1200F) && !this.claim.isCheckedAndNotNull(Rai300.M1200G) && !this.claim.isCheckedAndNotNull(Rai300.M1200H));
    }

    private boolean isHemiplegiaOrHemiparesis() {
        return this.claim.isCheckedAndNotNull(Rai300.I4900) && this.claim.getFunctionScore() <= 11;
    }

    public boolean isDepressed() {
        int d0300SeverityScore = this.claim.getAssessmentValue(Rai300.D0300);
        boolean result = d0300SeverityScore >= 10 && d0300SeverityScore != 99 || this.claim.getAssessmentValue(Rai300.D0600) >= 10;
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        NursingCmg cmg = null;
        if (this.isSpecialCareHighApplicable()) {
            cmg = this.evaluateSpecialCareHigh();
        } else if (this.isSpecialCareLowApplicable()) {
            cmg = this.evaluateSpecialCareLow();
        } else if (this.isClinicallyComplexApplicable()) {
            cmg = this.evaluateClinicallyComplex();
        }
        return SnfContext.trace("Final Special Care CMG", cmg);
    }

    public boolean isFoot() {
        return this.claim.isAnyAssessmentValuesPresent(EnumSet.of(Rai300.M1040A, Rai300.M1040B, Rai300.M1040C), "FOOT") && this.claim.isCheckedAndNotNull(Rai300.M1200I);
    }

    public boolean isStage2UlcerAndVenousArterialUlcer() {
        return this.getSkinTreatmentsCount() >= 2 && this.claim.isCheckedAndNotNull(Rai300.M1030) && this.claim.isCheckedAndNotNull(Rai300.M0300B1);
    }

    public boolean isTwoOrMoreVenousArterialUlcers() {
        return this.getSkinTreatmentsCount() >= 2 && this.claim.isAnyAssessmentValuesGreaterThanN(EnumSet.of(Rai300.M1030), 1);
    }

    public boolean isStage3Or4Ulcer() {
        return this.getSkinTreatmentsCount() >= 2 && this.claim.isAnyAssessmentValuesGreaterThanN(EnumSet.of(Rai300.M0300C1, Rai300.M0300D1, Rai300.M0300F1), 0);
    }

    public boolean isStage2Ulcer() {
        return this.getSkinTreatmentsCount() >= 2 && this.claim.isAnyAssessmentValuesGreaterThanN(EnumSet.of(Rai300.M0300B1), 1);
    }

    protected int getSkinTreatmentsCount() {
        int skinTreatmentsCount = this.claim.countAssessmentPresent(SKIN_TREATMENTS);
        int overlapCount = this.claim.countAssessmentPresent(SKIN_TREATMENTS_2);
        if (overlapCount >= 1) {
            ++skinTreatmentsCount;
        }
        return skinTreatmentsCount;
    }

    public boolean isFeedingTube() {
        return this.claim.isAnyAssessmentValuesPresent(EnumSet.of(Rai300.K0510B1, Rai300.K0510B2), "FEEDING TUBE") && this.isClassifiedTubeFeeding();
    }

    public boolean isRespiratoryOxyTherapy() {
        return this.claim.isCheckedAndNotNull(Rai300.I6300) && this.claim.isCheckedAndNotNull(Rai300.O0100C2);
    }

    public boolean isParkinson() {
        return this.claim.isCheckedAndNotNull(Rai300.I5300) && this.claim.getFunctionScore() <= 11;
    }

    public boolean isMultiSclerosis() {
        return this.claim.isCheckedAndNotNull(Rai300.I5200) && this.claim.getFunctionScore() <= 11;
    }

    public boolean isCerebralPalsy() {
        return this.claim.isCheckedAndNotNull(Rai300.I4400) && this.claim.getFunctionScore() <= 11;
    }

    public boolean isRespiratory() {
        return this.claim.hasAssessmentOf(Rai300.O0400D2, item -> item.getValueInt() == 7);
    }

    public boolean isSick() {
        Supplier<Boolean> fever = () -> this.claim.isCheckedAndNotNull(Rai300.J1550A);
        Supplier<Boolean> weightLo = () -> this.claim.hasAssessmentOf(Rai300.K0300, item -> 1 <= item.getValueInt() && item.getValueInt() <= 2);
        Supplier<Boolean> pneumoniaOrVomitting = () -> this.claim.isAnyAssessmentValuesPresent(EnumSet.of(Rai300.I2000, Rai300.J1550B), "PNEUMONIA/VOMITTING");
        Supplier<Boolean> feedingTube = this::isFeedingTube;
        return SnfContext.trace(fever.get() != false && (weightLo.get() != false || pneumoniaOrVomitting.get() != false || feedingTube.get() != false));
    }

    public boolean isParenteral() {
        return this.claim.isAnyAssessmentValuesPresent(EnumSet.of(Rai300.K0510A1, Rai300.K0510A2), "PARENTERAL");
    }

    protected boolean isClassifiedTubeFeeding() {
        Supplier<Boolean> k0710a3Equals3 = () -> this.claim.hasAssessmentOf(Rai300.K0710A3, item -> item.getValueInt() == 3);
        Supplier<Boolean> k0710a3Equals2 = () -> this.claim.hasAssessmentOf(Rai300.K0710A3, item -> item.getValueInt() == 2);
        Supplier<Boolean> k0710b3 = () -> this.claim.hasAssessmentOf(Rai300.K0710B3, item -> item.getValueInt() == 2);
        return k0710a3Equals3.get() != false || k0710a3Equals2.get() != false && k0710b3.get() != false;
    }

    public boolean isTroubleBreathing() {
        return this.claim.isCheckedAndNotNull(Rai300.I6200) && this.claim.isCheckedAndNotNull(Rai300.J1100C);
    }

    public boolean isComatose() {
        return this.claim.isComaAndNoActivities();
    }

    public boolean isSepticemia() {
        return this.claim.isCheckedAndNotNull(Rai300.I2100);
    }

    public boolean isDiabetes() {
        return this.claim.isCheckedAndNotNull(Rai300.I2900) && this.claim.hasAssessmentOf(Rai300.N0350A, item -> item.getValueInt() == 7) && this.claim.hasAssessmentOf(Rai300.N0350B, item -> item.getValueInt() >= 2);
    }

    public boolean isQuadriplegia() {
        return this.claim.isCheckedAndNotNull(Rai300.I5100) && this.claim.getFunctionScore() <= 11;
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }
}

