package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.ClinicalCategoryMappings;

public class ClinicalCategoryMappingRow extends BasicRow {

  public static final String SLP_ACUTE_NEUROLOGIC = "Acute Neurologic";

  private String pdsClinicalCategory;
  private String ptOtClinicalCategory;
  private String slpClinicalCategory;

  private ClinicalCategoryMappingRow() {
  }

  public ClinicalCategoryMappingRow(Integer lowVersion, Integer highVersion, String pdsClinicalCategory, String ptOtClinicalCategory,
      String slpClinicalCategory) {
    super(lowVersion, highVersion);
    this.pdsClinicalCategory = pdsClinicalCategory;
    this.ptOtClinicalCategory = ptOtClinicalCategory;
    this. slpClinicalCategory = slpClinicalCategory;
  }

  public String getPdsClinicalCategory() { return pdsClinicalCategory; }

  public String getPtOtClinicalCategory() {
    return ptOtClinicalCategory;
  }

  public String getSlpClinicalCategory() {
    return slpClinicalCategory;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = getHashCode(result, prime);
    result = prime * result
        + ((pdsClinicalCategory == null) ? 0 : pdsClinicalCategory.hashCode());
    result = prime * result
        + ((ptOtClinicalCategory == null) ? 0 : ptOtClinicalCategory.hashCode());
    result = prime * result
        + ((slpClinicalCategory == null) ? 0 : slpClinicalCategory.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    ClinicalCategoryMappingRow other = (ClinicalCategoryMappingRow) obj;
    if (super.equals(other) == false) {
      return false;
    }
    if (pdsClinicalCategory == null) {
      if (other.pdsClinicalCategory != null) {
        return false;
      }
    } else if (!pdsClinicalCategory.equals(other.pdsClinicalCategory)) {
      return false;
    }
    if (ptOtClinicalCategory == null) {
      if (other.ptOtClinicalCategory != null) {
        return false;
      }
    } else if (!ptOtClinicalCategory.equals(other.ptOtClinicalCategory)) {
      return false;
    }
    if (slpClinicalCategory == null) {
      if (other.slpClinicalCategory != null) {
        return false;
      }
    } else if (!slpClinicalCategory.equals(other.slpClinicalCategory)) {
      return false;
    }
    return true;
  }

  public static ClinicalCategoryMappingRow build(ClinicalCategoryMappings mapping) {
    return new ClinicalCategoryMappingRow(mapping.getLowVersion(), mapping.getHighVersion(),
        mapping.getPdxClinicalCategory(), mapping.getPtOtClinicalCategory(),
        mapping.getSlpClinicalCategory());
  }

}
