package gov.cms.grouper.snf.util;

import java.util.function.Supplier;

public class Lazy<T> implements Supplier<T> {

  private final Supplier<T> baseSupplier;
  private boolean init;
  private T value;

  public Lazy(Supplier<T> baseSupplier) {
    this.baseSupplier = baseSupplier;
  }

  @Override
  public T get() {
    if (!init) {
      value = baseSupplier.get();
      init = true;
    }
    return value;
  }
}
