package gov.cms.grouper.snf;

import com.mmm.his.cer.foundation.ComponentVersion;

import java.util.function.Function;

// Latest version should always be listed last
@SuppressWarnings("FieldNamingConvention")
public enum SnfComponentVersion implements ComponentVersion {
  r2(100, 104, gov.cms.grouper.snf.r2.SnfComponent::new),
  r3(105, 210, gov.cms.grouper.snf.r3.SnfComponent::new),
  r4(220, 230, gov.cms.grouper.snf.r4.SnfComponent::new),
  ;

  private final int from;
  private final int to;
  private final Function<Integer, SnfComponentAbstract> createComponent;

  SnfComponentVersion(int from, int to, Function<Integer, SnfComponentAbstract> createComponent) {
    this.from = from;
    this.to = to;
    this.createComponent = createComponent;
  }

  public static SnfComponentVersion of(Integer dataVersion) {
    if (dataVersion == null) return null;
    
    SnfComponentVersion result = null;

    for (SnfComponentVersion rel : SnfComponentVersion.values()) {
      if (rel.from <= dataVersion && dataVersion <= rel.to) {
        result = rel;
        break;
      }
    }

    return result;
  }

  @Override
  public String getPackageValue() { return name(); }

  public int getFrom() {
    return from;
  }

  public int getTo() {
    return to;
  }

  public Function<Integer, SnfComponentAbstract> getCreateComponent() {
    return createComponent;
  }

}
