package gov.cms.grouper.snf.model.table;

public abstract class BasicRow {

  public boolean isVersion(Integer check) {
    boolean passesLow = lowVersion == null || lowVersion <= check;
    boolean passesHigh = highVersion == null || highVersion >= check;
    return passesLow && passesHigh;
  }

  private Integer lowVersion;
  private Integer highVersion;

  protected BasicRow() {}

  protected BasicRow(Integer lowVersion, Integer highVersion) {
    this.lowVersion = lowVersion;
    this.highVersion = highVersion < lowVersion ? null : highVersion;
  }

  public Integer getLowVersion() {
    return lowVersion;
  }

  public Integer getHighVersion() {
    return highVersion;
  }

  /**
   * compute hashcode of Basic row.
   *
   * @param result running result of hashcode
   * @param prime  the prime that is being used
   * @return hashCode
   */
  public int getHashCode(int result, int prime) {
    result =
        prime * result + ((getLowVersion() == null) ? 0 : getLowVersion().hashCode());
    return result;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = getHashCode(result, prime);
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    BasicRow other = (BasicRow) obj;
    if (lowVersion == null) {
      if (other.lowVersion != null) {
        return false;
      }
    } else if (!lowVersion.equals(other.lowVersion)) {
      return false;
    }
    return true;
  }

}
