package gov.cms.grouper.snf.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.util.ClaimInfo;

/**
 * <a href="doc-files/mds-3.0-rai-manual-v1.17.1_october_2019.pdf#page=704" class="req">CATEGORY:
 * REDUCED PHYSICAL FUNCTION</a>
 */
public class ReducedPhysicalFunctionLogic extends SnfDataVersionImpl<NursingCmg> {

  private final BscpLogic bscp;
  private final ClaimInfo claim;

  public ReducedPhysicalFunctionLogic(ClaimInfo claim, BscpLogic bscp) {
    super(claim.getDataVersion());
    this.claim = claim;
    this.bscp = bscp;
  }

  /**
   * Select the PDPM Classification by using the PDPM Nursing Function Score and the Restorative
   * Nursing Count
   * <a href="doc-files/mds-3.0-rai-manual-v1.17.1_october_2019.pdf#page=704" class="req">Step3</a>
   */
  public NursingCmg step3(int restorativeNursingCount) {
    int functionScore = this.claim.getFunctionScore();

    NursingCmg cmg = null;
    if (0 <= functionScore && functionScore <= 5 && restorativeNursingCount >= 2) {
      cmg = NursingCmg.PDE2;
    } else if (0 <= functionScore && functionScore <= 5
        && 0 <= restorativeNursingCount && restorativeNursingCount <= 1) {
      cmg = NursingCmg.PDE1;
    } else if (6 <= functionScore && functionScore <= 14
        && restorativeNursingCount >= 2) {
      cmg = NursingCmg.PBC2;
    } else if (15 <= functionScore && functionScore <= 16
        && restorativeNursingCount >= 2) {
      cmg = NursingCmg.PA2;
    } else if (6 <= functionScore && functionScore <= 14
        && 0 <= restorativeNursingCount && restorativeNursingCount <= 1) {
      cmg = NursingCmg.PBC1;
    } else if (15 <= functionScore && functionScore <= 16
        && 0 <= restorativeNursingCount && restorativeNursingCount <= 1) {
      cmg = NursingCmg.PA1;
    }
    return SnfContext.trace(cmg);
  }

  @Override
  public NursingCmg exec() {
    final int restorativeNursingCount = this.bscp.step5();
    NursingCmg cmg = step3(restorativeNursingCount);
    return SnfContext.trace("Reduced Physical CMG", cmg);
  }
}
