/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimData;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.api.v2.SnfPaymentData;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.tables.DataTables;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class SnfPricerContext
extends CalculationContext<SnfClaimPricingRequest, SnfClaimPricingResponse> {
    public static final String DEFAULT_HIPPS_CODE = "ZZZZZ";
    public static final String REPLACEMENT_HIPPS_CODE = "PAYF1";
    @JsonIgnore
    private final DataTables dataTables;
    private BigDecimal wageIndex;
    private String hippsCode;
    private int currentDays;
    private int totalDays;
    private BigDecimal physicalTherapyRate;
    private BigDecimal occupationalTherapyRate;
    private BigDecimal speechLanguagePathologyRate;
    private BigDecimal nursingRate;
    private BigDecimal nonTherapyAncillaryRate;
    private BigDecimal nonCaseMixRate;
    private BigDecimal totalCalculatedPaymentRate;
    private BigDecimal physicalAndOccupationalTherapyUtilization;
    private BigDecimal nonTherapyAncillaryUtilization;
    private BigDecimal paymentRate;
    private BigDecimal paymentDifference;

    protected SnfPricerContext(SnfClaimPricingRequest request, SnfClaimPricingResponse response, DataTables dataTables) {
        super(request, response);
        this.dataTables = dataTables;
        SnfPaymentData paymentData = new SnfPaymentData();
        response.setPaymentData(paymentData);
        response.setCalculationVersion(this.getCalculationVersion());
        response.setReturnCodeData(ReturnCode.PDPM_GROUP_RATE_RETURNED_0.toReturnCodeData());
        paymentData.setTotalPayment(BigDecimal.ZERO);
        paymentData.setValueBasedPurchasingPaymentDifference(BigDecimal.ZERO);
        paymentData.setFinalWageIndex(BigDecimal.ZERO);
        paymentData.setRegionIndicator(this.hasRuralCbsa() ? "R" : "U");
    }

    @JsonIgnore
    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((SnfClaimPricingRequest)this.getInput()).getProviderData();
    }

    @JsonIgnore
    public SnfPaymentData getPaymentData() {
        return (SnfPaymentData)((SnfClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    @JsonIgnore
    public SnfClaimData getClaimData() {
        return (SnfClaimData)((SnfClaimPricingRequest)this.getInput()).getClaimData();
    }

    public void applyReturnCodeAndTerminate(ReturnCode returnCode) {
        ((SnfClaimPricingResponse)this.getOutput()).setReturnCodeData(returnCode.toReturnCodeData());
        this.setCalculationCompleted();
    }

    public boolean hasRuralCbsa() {
        String cbsaActualGeographicLocation = this.getProviderData().getCbsaActualGeographicLocation();
        return StringUtils.isNotBlank(cbsaActualGeographicLocation) && cbsaActualGeographicLocation.matches("\\d{2}");
    }

    public boolean hasAidsAdjustment() {
        List<String> diagnosisCodes = this.getClaimData().getDiagnosisCodes();
        return diagnosisCodes != null && diagnosisCodes.contains("B20");
    }

    public boolean hasQualityAdjustment() {
        return StringUtils.equals("1", this.getProviderData().getFederalPpsBlend());
    }

    public boolean hasSpecialWageIndexAdjustment() {
        return StringUtils.containsAny((CharSequence)this.getProviderData().getSpecialPaymentIndicator(), "Y", "1") && BigDecimalUtils.isGreaterThanZero(this.getProviderData().getSpecialWageIndex());
    }

    public abstract String getCalculationVersion();

    public abstract BigDecimal getWageIndexDecreaseCap();

    public abstract BigDecimal getUrbanNonCaseMixRate();

    public abstract BigDecimal getUrbanQualityAdjustedNonCaseMixRate();

    public abstract BigDecimal getRuralNonCaseMixRate();

    public abstract BigDecimal getRuralQualityAdjustedNonCaseMixRate();

    public abstract BigDecimal getLaborRate();

    public abstract BigDecimal getNonLaborRate();

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public BigDecimal getWageIndex() {
        return this.wageIndex;
    }

    @Generated
    public void setWageIndex(BigDecimal wageIndex) {
        this.wageIndex = wageIndex;
    }

    @Generated
    public String getHippsCode() {
        return this.hippsCode;
    }

    @Generated
    public void setHippsCode(String hippsCode) {
        this.hippsCode = hippsCode;
    }

    @Generated
    public int getCurrentDays() {
        return this.currentDays;
    }

    @Generated
    public void setCurrentDays(int currentDays) {
        this.currentDays = currentDays;
    }

    @Generated
    public int getTotalDays() {
        return this.totalDays;
    }

    @Generated
    public void setTotalDays(int totalDays) {
        this.totalDays = totalDays;
    }

    @Generated
    public BigDecimal getPhysicalTherapyRate() {
        return this.physicalTherapyRate;
    }

    @Generated
    public void setPhysicalTherapyRate(BigDecimal physicalTherapyRate) {
        this.physicalTherapyRate = physicalTherapyRate;
    }

    @Generated
    public BigDecimal getOccupationalTherapyRate() {
        return this.occupationalTherapyRate;
    }

    @Generated
    public void setOccupationalTherapyRate(BigDecimal occupationalTherapyRate) {
        this.occupationalTherapyRate = occupationalTherapyRate;
    }

    @Generated
    public BigDecimal getSpeechLanguagePathologyRate() {
        return this.speechLanguagePathologyRate;
    }

    @Generated
    public void setSpeechLanguagePathologyRate(BigDecimal speechLanguagePathologyRate) {
        this.speechLanguagePathologyRate = speechLanguagePathologyRate;
    }

    @Generated
    public BigDecimal getNursingRate() {
        return this.nursingRate;
    }

    @Generated
    public void setNursingRate(BigDecimal nursingRate) {
        this.nursingRate = nursingRate;
    }

    @Generated
    public BigDecimal getNonTherapyAncillaryRate() {
        return this.nonTherapyAncillaryRate;
    }

    @Generated
    public void setNonTherapyAncillaryRate(BigDecimal nonTherapyAncillaryRate) {
        this.nonTherapyAncillaryRate = nonTherapyAncillaryRate;
    }

    @Generated
    public BigDecimal getNonCaseMixRate() {
        return this.nonCaseMixRate;
    }

    @Generated
    public void setNonCaseMixRate(BigDecimal nonCaseMixRate) {
        this.nonCaseMixRate = nonCaseMixRate;
    }

    @Generated
    public BigDecimal getTotalCalculatedPaymentRate() {
        return this.totalCalculatedPaymentRate;
    }

    @Generated
    public void setTotalCalculatedPaymentRate(BigDecimal totalCalculatedPaymentRate) {
        this.totalCalculatedPaymentRate = totalCalculatedPaymentRate;
    }

    @Generated
    public BigDecimal getPhysicalAndOccupationalTherapyUtilization() {
        return this.physicalAndOccupationalTherapyUtilization;
    }

    @Generated
    public void setPhysicalAndOccupationalTherapyUtilization(BigDecimal physicalAndOccupationalTherapyUtilization) {
        this.physicalAndOccupationalTherapyUtilization = physicalAndOccupationalTherapyUtilization;
    }

    @Generated
    public BigDecimal getNonTherapyAncillaryUtilization() {
        return this.nonTherapyAncillaryUtilization;
    }

    @Generated
    public void setNonTherapyAncillaryUtilization(BigDecimal nonTherapyAncillaryUtilization) {
        this.nonTherapyAncillaryUtilization = nonTherapyAncillaryUtilization;
    }

    @Generated
    public BigDecimal getPaymentRate() {
        return this.paymentRate;
    }

    @Generated
    public void setPaymentRate(BigDecimal paymentRate) {
        this.paymentRate = paymentRate;
    }

    @Generated
    public BigDecimal getPaymentDifference() {
        return this.paymentDifference;
    }

    @Generated
    public void setPaymentDifference(BigDecimal paymentDifference) {
        this.paymentDifference = paymentDifference;
    }
}

