/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateTotalPaymentRate
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        BigDecimal physicalAndOccupationalTherapyFee = context.getPhysicalTherapyRate().add(context.getOccupationalTherapyRate()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal physicalAndOccupationalTherapyPortion = physicalAndOccupationalTherapyFee.multiply(context.getPhysicalAndOccupationalTherapyUtilization()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal nonTherapyAncillaryPortion = context.getNonTherapyAncillaryRate().multiply(context.getNonTherapyAncillaryUtilization()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal nursingSlpNcmPortion = context.getNursingRate().add(context.getSpeechLanguagePathologyRate()).add(context.getNonCaseMixRate()).multiply(BigDecimal.valueOf(context.getCurrentDays())).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalCaseMixPerDiem = physicalAndOccupationalTherapyPortion.add(nonTherapyAncillaryPortion).add(nursingSlpNcmPortion);
        BigDecimal laborPortion = totalCaseMixPerDiem.multiply(context.getLaborRate()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal adjustedLabor = laborPortion.multiply(context.getWageIndex()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal nonLaborPortion = totalCaseMixPerDiem.multiply(context.getNonLaborRate()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalLaborAdjustedRate = adjustedLabor.add(nonLaborPortion);
        context.setTotalCalculatedPaymentRate(totalLaborAdjustedRate.setScale(2, RoundingMode.HALF_UP));
    }
}

