/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import gov.cms.fiss.pricers.snf.core.tables.VariablePerDiemEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateUtilizationDays
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        int priorDays = context.getClaimData().getPdpmPriorDays();
        int totalDays = context.getTotalDays();
        BigDecimal ptOtUtilization = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal ntaUtilization = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        for (int i = priorDays + 1; i <= totalDays; ++i) {
            VariablePerDiemEntry entry = context.getDataTables().getVariablePerDiemAdjustmentFactors(i);
            ptOtUtilization = ptOtUtilization.add(entry.getPhysicalAndOccupationalAdjFactor());
            ntaUtilization = ntaUtilization.add(entry.getNonTherapyAncillaryAdjFactor());
        }
        context.setPhysicalAndOccupationalTherapyUtilization(ptOtUtilization);
        context.setNonTherapyAncillaryUtilization(ntaUtilization);
    }
}

